/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedExtensions;
import org.openapitools.openapidiff.core.model.ChangedResponse;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedApiResponse
implements ComposedChanged {
    private final ApiResponses oldApiResponses;
    private final ApiResponses newApiResponses;
    private final DiffContext context;
    private Map<String, ApiResponse> increased;
    private Map<String, ApiResponse> missing;
    private Map<String, ChangedResponse> changed;
    private ChangedExtensions extensions;

    public ChangedApiResponse(ApiResponses oldApiResponses, ApiResponses newApiResponses, DiffContext context) {
        this.oldApiResponses = oldApiResponses;
        this.newApiResponses = newApiResponses;
        this.context = context;
        this.missing = new LinkedHashMap<String, ApiResponse>();
        this.increased = new LinkedHashMap<String, ApiResponse>();
        this.changed = new LinkedHashMap<String, ChangedResponse>();
    }

    @Override
    public List<Changed> getChangedElements() {
        return Stream.concat(this.changed.values().stream(), Stream.of(this.extensions)).collect(Collectors.toList());
    }

    @Override
    public DiffResult isCoreChanged() {
        if (this.increased.isEmpty() && this.missing.isEmpty()) {
            return DiffResult.NO_CHANGES;
        }
        if (!this.increased.isEmpty() && this.missing.isEmpty()) {
            return DiffResult.COMPATIBLE;
        }
        return DiffResult.INCOMPATIBLE;
    }

    public ApiResponses getOldApiResponses() {
        return this.oldApiResponses;
    }

    public ApiResponses getNewApiResponses() {
        return this.newApiResponses;
    }

    public DiffContext getContext() {
        return this.context;
    }

    public Map<String, ApiResponse> getIncreased() {
        return this.increased;
    }

    public Map<String, ApiResponse> getMissing() {
        return this.missing;
    }

    public Map<String, ChangedResponse> getChanged() {
        return this.changed;
    }

    public ChangedExtensions getExtensions() {
        return this.extensions;
    }

    public ChangedApiResponse setIncreased(Map<String, ApiResponse> increased) {
        this.increased = increased;
        return this;
    }

    public ChangedApiResponse setMissing(Map<String, ApiResponse> missing) {
        this.missing = missing;
        return this;
    }

    public ChangedApiResponse setChanged(Map<String, ChangedResponse> changed) {
        this.changed = changed;
        return this;
    }

    public ChangedApiResponse setExtensions(ChangedExtensions extensions) {
        this.extensions = extensions;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedApiResponse that = (ChangedApiResponse)o;
        return Objects.equals(this.oldApiResponses, that.oldApiResponses) && Objects.equals(this.newApiResponses, that.newApiResponses) && Objects.equals(this.context, that.context) && Objects.equals(this.increased, that.increased) && Objects.equals(this.missing, that.missing) && Objects.equals(this.changed, that.changed) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.oldApiResponses, this.newApiResponses, this.context, this.increased, this.missing, this.changed, this.extensions);
    }

    public String toString() {
        return "ChangedApiResponse(oldApiResponses=" + this.getOldApiResponses() + ", newApiResponses=" + this.getNewApiResponses() + ", context=" + this.getContext() + ", increased=" + this.getIncreased() + ", missing=" + this.getMissing() + ", changed=" + this.getChanged() + ", extensions=" + this.getExtensions() + ")";
    }
}

