/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.util;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.SearchPhaseExecutionException;
import org.opensearch.action.search.ShardSearchFailure;
import org.opensearch.ad.common.exception.AnomalyDetectionException;
import org.opensearch.ad.common.exception.ResourceNotFoundException;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.Feature;
import org.opensearch.common.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.indices.InvalidIndexNameException;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;

public final class RestHandlerUtils {
    private static final Logger logger = LogManager.getLogger(RestHandlerUtils.class);
    public static final String _ID = "_id";
    public static final String _VERSION = "_version";
    public static final String _SEQ_NO = "_seq_no";
    public static final String IF_SEQ_NO = "if_seq_no";
    public static final String _PRIMARY_TERM = "_primary_term";
    public static final String IF_PRIMARY_TERM = "if_primary_term";
    public static final String REFRESH = "refresh";
    public static final String DETECTOR_ID = "detectorID";
    public static final String RESULT_INDEX = "resultIndex";
    public static final String ANOMALY_DETECTOR = "anomaly_detector";
    public static final String ANOMALY_DETECTOR_JOB = "anomaly_detector_job";
    public static final String REALTIME_TASK = "realtime_detection_task";
    public static final String HISTORICAL_ANALYSIS_TASK = "historical_analysis_task";
    public static final String RUN = "_run";
    public static final String PREVIEW = "_preview";
    public static final String START_JOB = "_start";
    public static final String STOP_JOB = "_stop";
    public static final String PROFILE = "_profile";
    public static final String TYPE = "type";
    public static final String ENTITY = "entity";
    public static final String COUNT = "count";
    public static final String MATCH = "match";
    public static final String RESULTS = "results";
    public static final String TOP_ANOMALIES = "_topAnomalies";
    public static final String VALIDATE = "_validate";
    public static final ToXContent.MapParams XCONTENT_WITH_TYPE = new ToXContent.MapParams((Map)ImmutableMap.of((Object)"with_type", (Object)"true"));
    public static final String OPENSEARCH_DASHBOARDS_USER_AGENT = "OpenSearch Dashboards";
    public static final String[] UI_METADATA_EXCLUDE = new String[]{"ui_metadata"};

    private RestHandlerUtils() {
    }

    public static FetchSourceContext getSourceContext(RestRequest request, SearchSourceBuilder searchSourceBuilder) {
        String userAgent = RestHandlerUtils.coalesceToEmpty(request.header("User-Agent"));
        if (searchSourceBuilder.fetchSource() != null) {
            if (userAgent.contains(OPENSEARCH_DASHBOARDS_USER_AGENT)) {
                return new FetchSourceContext(true, searchSourceBuilder.fetchSource().includes(), searchSourceBuilder.fetchSource().excludes());
            }
            String[] newArray = (String[])ArrayUtils.addAll((Object[])searchSourceBuilder.fetchSource().excludes(), (Object[])UI_METADATA_EXCLUDE);
            return new FetchSourceContext(true, searchSourceBuilder.fetchSource().includes(), newArray);
        }
        if (!userAgent.contains(OPENSEARCH_DASHBOARDS_USER_AGENT)) {
            return new FetchSourceContext(true, Strings.EMPTY_ARRAY, UI_METADATA_EXCLUDE);
        }
        return null;
    }

    public static XContentParser createXContentParser(RestChannel channel, BytesReference bytesReference) throws IOException {
        return XContentHelper.createParser((NamedXContentRegistry)channel.request().getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)bytesReference, (MediaType)XContentType.JSON);
    }

    public static XContentParser createXContentParserFromRegistry(NamedXContentRegistry xContentRegistry, BytesReference bytesReference) throws IOException {
        return XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)bytesReference, (MediaType)XContentType.JSON);
    }

    public static String checkAnomalyDetectorFeaturesSyntax(AnomalyDetector anomalyDetector, int maxAnomalyFeatures) {
        List<Feature> features = anomalyDetector.getFeatureAttributes();
        if (features != null) {
            if (features.size() > maxAnomalyFeatures) {
                return "Can't create more than " + maxAnomalyFeatures + " anomaly features";
            }
            return RestHandlerUtils.validateFeaturesConfig(anomalyDetector.getFeatureAttributes());
        }
        return null;
    }

    private static String validateFeaturesConfig(List<Feature> features) {
        HashSet duplicateFeatureNames = new HashSet();
        HashSet featureNames = new HashSet();
        HashSet duplicateFeatureAggNames = new HashSet();
        HashSet featureAggNames = new HashSet();
        features.forEach(feature -> {
            if (!featureNames.add(feature.getName())) {
                duplicateFeatureNames.add(feature.getName());
            }
            if (!featureAggNames.add(feature.getAggregation().getName())) {
                duplicateFeatureAggNames.add(feature.getAggregation().getName());
            }
        });
        StringBuilder errorMsgBuilder = new StringBuilder();
        if (duplicateFeatureNames.size() > 0) {
            errorMsgBuilder.append("Detector has duplicate feature names: ");
            errorMsgBuilder.append(String.join((CharSequence)", ", duplicateFeatureNames));
        }
        if (errorMsgBuilder.length() != 0 && duplicateFeatureAggNames.size() > 0) {
            errorMsgBuilder.append(". ");
        }
        if (duplicateFeatureAggNames.size() > 0) {
            errorMsgBuilder.append(CommonErrorMessages.DUPLICATE_FEATURE_AGGREGATION_NAMES);
            errorMsgBuilder.append(String.join((CharSequence)", ", duplicateFeatureAggNames));
        }
        return errorMsgBuilder.toString();
    }

    public static boolean isExceptionCausedByInvalidQuery(Exception ex) {
        if (!(ex instanceof SearchPhaseExecutionException)) {
            return false;
        }
        SearchPhaseExecutionException exception = (SearchPhaseExecutionException)ex;
        for (ShardSearchFailure failure : exception.shardFailures()) {
            if (RestStatus.BAD_REQUEST == failure.status() && failure.getCause() instanceof IllegalArgumentException) continue;
            return false;
        }
        return true;
    }

    public static <T> ActionListener wrapRestActionListener(ActionListener<T> actionListener, String generalErrorMessage) {
        return ActionListener.wrap(r -> actionListener.onResponse(r), e -> {
            logger.error("Wrap exception before sending back to user", (Throwable)e);
            Throwable cause = Throwables.getRootCause((Throwable)e);
            if (RestHandlerUtils.isProperExceptionToReturn(e)) {
                actionListener.onFailure(e);
            } else if (RestHandlerUtils.isProperExceptionToReturn(cause)) {
                actionListener.onFailure((Exception)cause);
            } else {
                RestStatus status = RestHandlerUtils.isBadRequest(e) ? RestStatus.BAD_REQUEST : RestStatus.INTERNAL_SERVER_ERROR;
                String errorMessage = generalErrorMessage;
                if (RestHandlerUtils.isBadRequest(e) || e instanceof AnomalyDetectionException) {
                    errorMessage = e.getMessage();
                } else if (cause != null && (RestHandlerUtils.isBadRequest(cause) || cause instanceof AnomalyDetectionException)) {
                    errorMessage = cause.getMessage();
                }
                actionListener.onFailure((Exception)new OpenSearchStatusException(errorMessage, status, new Object[0]));
            }
        });
    }

    public static boolean isBadRequest(Throwable e) {
        if (e == null) {
            return false;
        }
        return e instanceof IllegalArgumentException || e instanceof ResourceNotFoundException;
    }

    public static boolean isProperExceptionToReturn(Throwable e) {
        if (e == null) {
            return false;
        }
        return e instanceof OpenSearchStatusException || e instanceof IndexNotFoundException || e instanceof InvalidIndexNameException;
    }

    private static String coalesceToEmpty(@Nullable String s) {
        return s == null ? "" : s;
    }
}

