/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.cli;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.Response;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.cli.AbstractCli;
import org.ldaptive.io.Dsmlv1Writer;
import org.ldaptive.io.LdifWriter;
import org.ldaptive.io.SearchResultWriter;
import org.ldaptive.props.BindConnectionInitializerPropertySource;
import org.ldaptive.props.ConnectionConfigPropertySource;
import org.ldaptive.props.PropertySource;
import org.ldaptive.props.SearchRequestPropertySource;
import org.ldaptive.props.SslConfigPropertySource;
import org.ldaptive.ssl.SslConfig;

public class SearchOperationCli
extends AbstractCli {
    private static final String OPT_DSMLV1 = "dsmlv1";
    private static final String COMMAND_NAME = "ldapsearch";

    public static void main(String[] args) {
        SearchOperationCli cli = new SearchOperationCli();
        int status = cli.performAction(args);
        System.exit(status);
    }

    @Override
    protected void initOptions() {
        this.options.addOption(new Option(OPT_DSMLV1, false, "output results in DSML v1"));
        Map<String, String> desc = this.getArgDesc(ConnectionConfig.class, SslConfig.class, SearchRequest.class);
        for (String s : ConnectionConfigPropertySource.getProperties()) {
            this.options.addOption(new Option(s, true, desc.get(s)));
        }
        for (String s : SslConfigPropertySource.getProperties()) {
            this.options.addOption(new Option(s, true, desc.get(s)));
        }
        for (String s : BindConnectionInitializerPropertySource.getProperties()) {
            this.options.addOption(new Option(s, true, desc.get(s)));
        }
        for (String s : SearchRequestPropertySource.getProperties()) {
            this.options.addOption(new Option(s, true, desc.get(s)));
        }
        super.initOptions();
    }

    protected SearchRequest initSearchRequest(CommandLine line) {
        SearchRequest request = new SearchRequest();
        SearchRequestPropertySource srSource = new SearchRequestPropertySource(request, this.getPropertiesFromOptions(PropertySource.PropertyDomain.LDAP.value(), line));
        srSource.initialize();
        return request;
    }

    @Override
    protected int dispatch(CommandLine line) throws Exception {
        if (line.hasOption(OPT_DSMLV1)) {
            this.outputDsmlv1 = true;
        }
        if (!line.hasOption("help")) {
            return this.search(this.initConnectionFactory(line), this.initSearchRequest(line));
        }
        this.printHelp();
        return -1;
    }

    protected int search(ConnectionFactory cf, SearchRequest request) throws Exception {
        Connection conn = cf.getConnection();
        conn.open();
        SearchOperation op = new SearchOperation(conn);
        Response response = op.execute(request);
        SearchResult result = (SearchResult)response.getResult();
        SearchResultWriter writer = this.outputDsmlv1 ? new Dsmlv1Writer(new BufferedWriter(new OutputStreamWriter(System.out))) : new LdifWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
        writer.write(result);
        conn.close();
        return response.getResultCode().value();
    }

    @Override
    protected String getCommandName() {
        return COMMAND_NAME;
    }
}

