/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.validation;

import java.util.Map;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.compress.NotXContentException;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.Strings;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import org.opensearch.security.dlic.rest.validation.PasswordValidator;
import org.opensearch.security.ssl.util.Utils;

public class CredentialsValidator
extends AbstractConfigurationValidator {
    private final PasswordValidator passwordValidator;

    public CredentialsValidator(RestRequest request, BytesReference ref, Settings opensearchSettings, Object ... param) {
        super(request, ref, opensearchSettings, param);
        this.payloadMandatory = true;
        this.passwordValidator = PasswordValidator.of(opensearchSettings);
        this.allowedKeys.put("hash", AbstractConfigurationValidator.DataType.STRING);
        this.allowedKeys.put("password", AbstractConfigurationValidator.DataType.STRING);
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        if ((this.request.method() == RestRequest.Method.PUT || this.request.method() == RestRequest.Method.PATCH) && this.content != null && this.content.length() > 1) {
            try {
                Map contentAsMap = (Map)XContentHelper.convertToMap((BytesReference)this.content, (boolean)false, (XContentType)XContentType.JSON).v2();
                String password = (String)contentAsMap.get("password");
                if (password != null) {
                    if (password.isEmpty()) {
                        this.errorType = AbstractConfigurationValidator.ErrorType.INVALID_PASSWORD;
                        return false;
                    }
                    String username = Utils.coalesce(this.request.param("name"), this.hasParams() ? (String)this.param[0] : null);
                    if (Strings.isNullOrEmpty((String)username)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Unable to validate username because no user is given");
                        }
                        return false;
                    }
                    AbstractConfigurationValidator.ErrorType passwordValidationResult = this.passwordValidator.validate(username, password);
                    if (passwordValidationResult != AbstractConfigurationValidator.ErrorType.NONE) {
                        this.errorType = passwordValidationResult;
                        return false;
                    }
                }
            }
            catch (NotXContentException e) {
                this.log.error("Invalid xContent: " + e, (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

