/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.RealtimeRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.support.ConfigConstants;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportRequest;

public class SecurityIndexAccessEvaluator {
    Logger log = LogManager.getLogger(this.getClass());
    private final String securityIndex;
    private final AuditLog auditLog;
    private final WildcardMatcher securityDeniedActionMatcher;
    private final IndexResolverReplacer irr;
    private final boolean filterSecurityIndex;
    private final WildcardMatcher systemIndexMatcher;
    private final boolean systemIndexEnabled;

    public SecurityIndexAccessEvaluator(Settings settings, AuditLog auditLog, IndexResolverReplacer irr) {
        this.securityIndex = settings.get("plugins.security.config_index_name", ".opendistro_security");
        this.auditLog = auditLog;
        this.irr = irr;
        this.filterSecurityIndex = settings.getAsBoolean("plugins.security.filter_securityindex_from_all_requests", Boolean.valueOf(false));
        this.systemIndexMatcher = WildcardMatcher.from(settings.getAsList("plugins.security.system_indices.indices", ConfigConstants.SECURITY_SYSTEM_INDICES_DEFAULT));
        this.systemIndexEnabled = settings.getAsBoolean("plugins.security.system_indices.enabled", ConfigConstants.SECURITY_SYSTEM_INDICES_ENABLED_DEFAULT);
        boolean restoreSecurityIndexEnabled = settings.getAsBoolean("plugins.security.unsupported.restore.securityindex.enabled", Boolean.valueOf(false));
        ArrayList<String> securityIndexDeniedActionPatternsList = new ArrayList<String>();
        securityIndexDeniedActionPatternsList.add("indices:data/write*");
        securityIndexDeniedActionPatternsList.add("indices:admin/delete*");
        securityIndexDeniedActionPatternsList.add("indices:admin/mapping/delete*");
        securityIndexDeniedActionPatternsList.add("indices:admin/mapping/put*");
        securityIndexDeniedActionPatternsList.add("indices:admin/freeze*");
        securityIndexDeniedActionPatternsList.add("indices:admin/settings/update*");
        securityIndexDeniedActionPatternsList.add("indices:admin/aliases");
        ArrayList<String> securityIndexDeniedActionPatternsListNoSnapshot = new ArrayList<String>();
        securityIndexDeniedActionPatternsListNoSnapshot.addAll(securityIndexDeniedActionPatternsList);
        securityIndexDeniedActionPatternsListNoSnapshot.add("indices:admin/close*");
        securityIndexDeniedActionPatternsListNoSnapshot.add("cluster:admin/snapshot/restore*");
        this.securityDeniedActionMatcher = WildcardMatcher.from(restoreSecurityIndexEnabled ? securityIndexDeniedActionPatternsList : securityIndexDeniedActionPatternsListNoSnapshot);
    }

    public PrivilegesEvaluatorResponse evaluate(ActionRequest request, Task task, String action, IndexResolverReplacer.Resolved requestedResolved, PrivilegesEvaluatorResponse presponse) {
        boolean isDebugEnabled = this.log.isDebugEnabled();
        if (this.securityDeniedActionMatcher.test(action)) {
            if (requestedResolved.isLocalAll()) {
                if (this.filterSecurityIndex) {
                    this.irr.replace((TransportRequest)request, false, "*", "-" + this.securityIndex);
                    if (isDebugEnabled) {
                        this.log.debug("Filtered '{}'from {}, resulting list with *,-{} is {}", (Object)this.securityIndex, (Object)requestedResolved, (Object)this.securityIndex, (Object)this.irr.resolveRequest(request));
                    }
                    return presponse;
                }
                this.auditLog.logSecurityIndexAttempt((TransportRequest)request, action, task);
                this.log.warn("{} for '_all' indices is not allowed for a regular user", (Object)action);
                presponse.allowed = false;
                return presponse.markComplete();
            }
            if (this.matchAnySystemIndices(requestedResolved)) {
                if (this.filterSecurityIndex) {
                    HashSet<String> allWithoutSecurity = new HashSet<String>(requestedResolved.getAllIndices());
                    allWithoutSecurity.remove(this.securityIndex);
                    if (allWithoutSecurity.isEmpty()) {
                        if (isDebugEnabled) {
                            this.log.debug("Filtered '{}' but resulting list is empty", (Object)this.securityIndex);
                        }
                        presponse.allowed = false;
                        return presponse.markComplete();
                    }
                    this.irr.replace((TransportRequest)request, false, allWithoutSecurity.toArray(new String[0]));
                    if (isDebugEnabled) {
                        this.log.debug("Filtered '{}', resulting list is {}", (Object)this.securityIndex, allWithoutSecurity);
                    }
                    return presponse;
                }
                this.auditLog.logSecurityIndexAttempt((TransportRequest)request, action, task);
                String foundSystemIndexes = this.getProtectedIndexes(requestedResolved).stream().collect(Collectors.joining(", "));
                this.log.warn("{} for '{}' index is not allowed for a regular user", (Object)action, (Object)foundSystemIndexes);
                presponse.allowed = false;
                return presponse.markComplete();
            }
        }
        if (requestedResolved.isLocalAll() || requestedResolved.getAllIndices().contains(this.securityIndex) || this.matchAnySystemIndices(requestedResolved)) {
            if (request instanceof SearchRequest) {
                ((SearchRequest)request).requestCache(Boolean.FALSE);
                if (isDebugEnabled) {
                    this.log.debug("Disable search request cache for this request");
                }
            }
            if (request instanceof RealtimeRequest) {
                ((RealtimeRequest)request).realtime(Boolean.FALSE.booleanValue());
                if (isDebugEnabled) {
                    this.log.debug("Disable realtime for this request");
                }
            }
        }
        return presponse;
    }

    private boolean matchAnySystemIndices(IndexResolverReplacer.Resolved requestedResolved) {
        return !this.getProtectedIndexes(requestedResolved).isEmpty();
    }

    private List<String> getProtectedIndexes(IndexResolverReplacer.Resolved requestedResolved) {
        List<String> protectedIndexes = requestedResolved.getAllIndices().stream().filter(this.securityIndex::equals).collect(Collectors.toList());
        if (this.systemIndexEnabled) {
            protectedIndexes.addAll(this.systemIndexMatcher.getMatchAny(requestedResolved.getAllIndices(), Collectors.toList()));
        }
        return protectedIndexes;
    }
}

