/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.request;

import java.io.IOException;
import java.util.Collections;
import org.json.JSONException;
import org.json.JSONObject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.SearchModule;
import org.opensearch.sql.legacy.exception.SqlParseException;

public class SqlRequest {
    public static final SqlRequest NULL = new SqlRequest("", null);
    String sql;
    JSONObject jsonContent;
    String cursor;
    Integer fetchSize;

    public SqlRequest(String sql, JSONObject jsonContent) {
        this.sql = sql;
        this.jsonContent = jsonContent;
    }

    public SqlRequest(String cursor) {
        this.cursor = cursor;
    }

    public SqlRequest(String sql, Integer fetchSize, JSONObject jsonContent) {
        this.sql = sql;
        this.fetchSize = fetchSize;
        this.jsonContent = jsonContent;
    }

    private static boolean isValidJson(String json) {
        try {
            new JSONObject(json);
        }
        catch (JSONException e) {
            return false;
        }
        return true;
    }

    public String getSql() {
        return this.sql;
    }

    public String cursor() {
        return this.cursor;
    }

    public Integer fetchSize() {
        return this.fetchSize;
    }

    public JSONObject getJsonContent() {
        return this.jsonContent;
    }

    private String getFilterObjectAsString(JSONObject jsonContent) {
        String filterVal = jsonContent.getJSONObject("filter").toString();
        return "{\"filter\":" + filterVal + "}";
    }

    private boolean hasFilterInRequest() {
        return this.jsonContent != null && this.jsonContent.has("filter");
    }

    private void addFilterFromJson(BoolQueryBuilder boolQuery) throws SqlParseException {
        try {
            String filter = this.getFilterObjectAsString(this.jsonContent);
            SearchModule searchModule = new SearchModule(Settings.EMPTY, Collections.emptyList());
            XContentParser parser = XContentFactory.xContent((MediaType)XContentType.JSON).createParser(new NamedXContentRegistry(searchModule.getNamedXContents()), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, filter);
            parser.nextToken();
            boolQuery.filter((QueryBuilder)BoolQueryBuilder.fromXContent((XContentParser)parser));
        }
        catch (IOException e) {
            throw new SqlParseException("Unable to parse 'filter' in JSON request: " + e.getMessage());
        }
    }

    public BoolQueryBuilder checkAndAddFilter(BoolQueryBuilder boolQuery) throws SqlParseException {
        if (this.hasFilterInRequest()) {
            boolQuery = boolQuery == null ? new BoolQueryBuilder() : boolQuery;
            this.addFilterFromJson(boolQuery);
        }
        return boolQuery;
    }
}

