/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.functions.response;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.prometheus.functions.response.QueryRangeFunctionResponseHandle;

public class DefaultQueryRangeFunctionResponseHandle
implements QueryRangeFunctionResponseHandle {
    private final JSONObject responseObject;
    private Iterator<ExprValue> responseIterator;
    private ExecutionEngine.Schema schema;

    public DefaultQueryRangeFunctionResponseHandle(JSONObject responseObject) {
        this.responseObject = responseObject;
        this.constructIteratorAndSchema();
    }

    private void constructIteratorAndSchema() {
        ArrayList<ExprTupleValue> result = new ArrayList<ExprTupleValue>();
        ArrayList<ExecutionEngine.Schema.Column> columnList = new ArrayList();
        if ("matrix".equals(this.responseObject.getString("resultType"))) {
            JSONArray itemArray = this.responseObject.getJSONArray("result");
            for (int i = 0; i < itemArray.length(); ++i) {
                JSONObject item = itemArray.getJSONObject(i);
                JSONObject metric = item.getJSONObject("metric");
                JSONArray values = item.getJSONArray("values");
                if (i == 0) {
                    columnList = this.getColumnList(metric);
                }
                for (int j = 0; j < values.length(); ++j) {
                    LinkedHashMap<String, ExprValue> linkedHashMap = DefaultQueryRangeFunctionResponseHandle.extractRow(metric, values.getJSONArray(j), columnList);
                    result.add(new ExprTupleValue(linkedHashMap));
                }
            }
        } else {
            throw new RuntimeException(String.format("Unexpected Result Type: %s during Prometheus Response Parsing. 'matrix' resultType is expected", this.responseObject.getString("resultType")));
        }
        this.schema = new ExecutionEngine.Schema(columnList);
        this.responseIterator = result.iterator();
    }

    @NotNull
    private static LinkedHashMap<String, ExprValue> extractRow(JSONObject metric, JSONArray values, List<ExecutionEngine.Schema.Column> columnList) {
        LinkedHashMap<String, ExprValue> linkedHashMap = new LinkedHashMap<String, ExprValue>();
        for (ExecutionEngine.Schema.Column column : columnList) {
            if ("@timestamp".equals(column.getName())) {
                linkedHashMap.put("@timestamp", (ExprValue)new ExprTimestampValue(Instant.ofEpochMilli((long)(values.getDouble(0) * 1000.0))));
                continue;
            }
            if (column.getName().equals("@value")) {
                linkedHashMap.put("@value", (ExprValue)new ExprDoubleValue((Number)values.getDouble(1)));
                continue;
            }
            linkedHashMap.put(column.getName(), (ExprValue)new ExprStringValue(metric.getString(column.getName())));
        }
        return linkedHashMap;
    }

    private List<ExecutionEngine.Schema.Column> getColumnList(JSONObject metric) {
        ArrayList<ExecutionEngine.Schema.Column> columnList = new ArrayList<ExecutionEngine.Schema.Column>();
        columnList.add(new ExecutionEngine.Schema.Column("@timestamp", "@timestamp", (ExprType)ExprCoreType.TIMESTAMP));
        columnList.add(new ExecutionEngine.Schema.Column("@value", "@value", (ExprType)ExprCoreType.DOUBLE));
        for (String key : metric.keySet()) {
            columnList.add(new ExecutionEngine.Schema.Column(key, key, (ExprType)ExprCoreType.STRING));
        }
        return columnList;
    }

    @Override
    public boolean hasNext() {
        return this.responseIterator.hasNext();
    }

    @Override
    public ExprValue next() {
        return this.responseIterator.next();
    }

    @Override
    public ExecutionEngine.Schema schema() {
        return this.schema;
    }
}

