# `MD023` - Headings must start at the beginning of the line

Tags: `headers`, `headings`, `spaces`

Aliases: `header-start-left`, `heading-start-left`

Fixable: Some violations can be fixed by tooling

This rule is triggered when a heading is indented by one or more spaces:

```markdown
Some text

  # Indented heading
```

To fix this, ensure that all headings start at the beginning of the line:

```markdown
Some text

# Heading
```

Rationale: Headings that don't start at the beginning of the line will not be
parsed as headings, and will instead appear as regular text.
