# `MD045` - Images should have alternate text (alt text)

Tags: `accessibility`, `images`

Aliases: `no-alt-text`

This rule is triggered when an image is missing alternate text (alt text)
information.

Alternate text is commonly specified inline as:

```markdown
![Alternate text](image.jpg)
```

Or with reference syntax as:

```markdown
![Alternate text][ref]

...

[ref]: image.jpg "Optional title"
```

Guidance for writing alternate text is available from the [W3C][w3c],
[Wikipedia][wikipedia], and [other locations][phase2technology].

Rationale: Alternate text is important for accessibility and describes the
content of an image for people who may not be able to see it.

[phase2technology]: https://www.phase2technology.com/blog/no-more-excuses
[w3c]: https://www.w3.org/WAI/alt/
[wikipedia]: https://en.wikipedia.org/wiki/Alt_attribute
