/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest.handler;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsAction;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.ad.common.exception.ADValidationException;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.feature.SearchFeatureDao;
import org.opensearch.ad.indices.AnomalyDetectionIndices;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.model.ADTaskType;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.DetectorValidationIssueType;
import org.opensearch.ad.model.Feature;
import org.opensearch.ad.model.MergeableList;
import org.opensearch.ad.model.ValidationAspect;
import org.opensearch.ad.rest.RestValidateAnomalyDetectorAction;
import org.opensearch.ad.rest.handler.AnomalyDetectorActionHandler;
import org.opensearch.ad.rest.handler.ModelValidationActionHandler;
import org.opensearch.ad.settings.NumericSetting;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.IndexAnomalyDetectorResponse;
import org.opensearch.ad.util.MultiResponsesDelegateActionListener;
import org.opensearch.ad.util.ParseUtils;
import org.opensearch.ad.util.RestHandlerUtils;
import org.opensearch.ad.util.SecurityClientUtil;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.TransportService;

public abstract class AbstractAnomalyDetectorActionHandler<T extends ActionResponse> {
    public static final String EXCEEDED_MAX_MULTI_ENTITY_DETECTORS_PREFIX_MSG = "Can't create more than %d multi-entity anomaly detectors.";
    public static final String EXCEEDED_MAX_SINGLE_ENTITY_DETECTORS_PREFIX_MSG = "Can't create more than %d single-entity anomaly detectors.";
    public static final String NO_DOCS_IN_USER_INDEX_MSG = "Can't create anomaly detector as no document is found in the indices: ";
    public static final String ONLY_ONE_CATEGORICAL_FIELD_ERR_MSG = "We can have only one categorical field.";
    public static final String CATEGORICAL_FIELD_TYPE_ERR_MSG = "A categorical field must be of type keyword or ip.";
    public static final String CATEGORY_NOT_FOUND_ERR_MSG = "Can't find the categorical field %s";
    public static final String DUPLICATE_DETECTOR_MSG = "Cannot create anomaly detector with name [%s] as it's already used by detector %s";
    public static final String NAME_REGEX = "[a-zA-Z0-9._-]+";
    public static final Integer MAX_DETECTOR_NAME_SIZE = 64;
    private static final Set<ValidationAspect> DEFAULT_VALIDATION_ASPECTS = Sets.newHashSet((Object[])new ValidationAspect[]{ValidationAspect.DETECTOR});
    protected final AnomalyDetectionIndices anomalyDetectionIndices;
    protected final String detectorId;
    protected final Long seqNo;
    protected final Long primaryTerm;
    protected final WriteRequest.RefreshPolicy refreshPolicy;
    protected final AnomalyDetector anomalyDetector;
    protected final ClusterService clusterService;
    protected final Logger logger = LogManager.getLogger(AbstractAnomalyDetectorActionHandler.class);
    protected final TimeValue requestTimeout;
    protected final Integer maxSingleEntityAnomalyDetectors;
    protected final Integer maxMultiEntityAnomalyDetectors;
    protected final Integer maxAnomalyFeatures;
    protected final AnomalyDetectorActionHandler handler = new AnomalyDetectorActionHandler();
    protected final RestRequest.Method method;
    protected final Client client;
    protected final SecurityClientUtil clientUtil;
    protected final TransportService transportService;
    protected final NamedXContentRegistry xContentRegistry;
    protected final ActionListener<T> listener;
    protected final User user;
    protected final ADTaskManager adTaskManager;
    protected final SearchFeatureDao searchFeatureDao;
    protected final boolean isDryRun;
    protected final Clock clock;
    protected final String validationType;
    protected final Settings settings;

    public AbstractAnomalyDetectorActionHandler(ClusterService clusterService, Client client, SecurityClientUtil clientUtil, TransportService transportService, ActionListener<T> listener, AnomalyDetectionIndices anomalyDetectionIndices, String detectorId, Long seqNo, Long primaryTerm, WriteRequest.RefreshPolicy refreshPolicy, AnomalyDetector anomalyDetector, TimeValue requestTimeout, Integer maxSingleEntityAnomalyDetectors, Integer maxMultiEntityAnomalyDetectors, Integer maxAnomalyFeatures, RestRequest.Method method, NamedXContentRegistry xContentRegistry, User user, ADTaskManager adTaskManager, SearchFeatureDao searchFeatureDao, String validationType, boolean isDryRun, Clock clock, Settings settings) {
        this.clusterService = clusterService;
        this.client = client;
        this.clientUtil = clientUtil;
        this.transportService = transportService;
        this.anomalyDetectionIndices = anomalyDetectionIndices;
        this.listener = listener;
        this.detectorId = detectorId;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.refreshPolicy = refreshPolicy;
        this.anomalyDetector = anomalyDetector;
        this.requestTimeout = requestTimeout;
        this.maxSingleEntityAnomalyDetectors = maxSingleEntityAnomalyDetectors;
        this.maxMultiEntityAnomalyDetectors = maxMultiEntityAnomalyDetectors;
        this.maxAnomalyFeatures = maxAnomalyFeatures;
        this.method = method;
        this.xContentRegistry = xContentRegistry;
        this.user = user;
        this.adTaskManager = adTaskManager;
        this.searchFeatureDao = searchFeatureDao;
        this.validationType = validationType;
        this.isDryRun = isDryRun;
        this.clock = clock;
        this.settings = settings;
    }

    public void start() {
        String resultIndex = this.anomalyDetector.getResultIndex();
        if (resultIndex == null) {
            this.createOrUpdateDetector();
            return;
        }
        if (this.isDryRun) {
            if (this.anomalyDetectionIndices.doesIndexExist(resultIndex)) {
                this.anomalyDetectionIndices.validateCustomResultIndexAndExecute(resultIndex, () -> this.createOrUpdateDetector(), ActionListener.wrap(r -> this.createOrUpdateDetector(), ex -> {
                    this.logger.error(ex);
                    this.listener.onFailure((Exception)new ADValidationException(ex.getMessage(), DetectorValidationIssueType.RESULT_INDEX, ValidationAspect.DETECTOR));
                }));
                return;
            }
            this.createOrUpdateDetector();
            return;
        }
        this.anomalyDetectionIndices.initCustomResultIndexAndExecute(resultIndex, () -> this.createOrUpdateDetector(), this.listener);
    }

    private void createOrUpdateDetector() {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            if (!this.anomalyDetectionIndices.doesAnomalyDetectorIndexExist() && !this.isDryRun) {
                this.logger.info("AnomalyDetector Indices do not exist");
                this.anomalyDetectionIndices.initAnomalyDetectorIndex((ActionListener<CreateIndexResponse>)ActionListener.wrap(response -> this.onCreateMappingsResponse((CreateIndexResponse)response, false), exception -> this.listener.onFailure(exception)));
            } else {
                this.logger.info("AnomalyDetector Indices do exist, calling prepareAnomalyDetectorIndexing");
                this.logger.info("DryRun variable " + this.isDryRun);
                this.validateDetectorName(this.isDryRun);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to create or update detector " + this.detectorId, (Throwable)e);
            this.listener.onFailure(e);
        }
    }

    protected void validateDetectorName(boolean indexingDryRun) {
        if (!this.anomalyDetector.getName().matches(NAME_REGEX)) {
            this.listener.onFailure((Exception)new ADValidationException(CommonErrorMessages.INVALID_DETECTOR_NAME, DetectorValidationIssueType.NAME, ValidationAspect.DETECTOR));
            return;
        }
        if (this.anomalyDetector.getName().length() > MAX_DETECTOR_NAME_SIZE) {
            this.listener.onFailure((Exception)new ADValidationException(CommonErrorMessages.INVALID_DETECTOR_NAME_SIZE, DetectorValidationIssueType.NAME, ValidationAspect.DETECTOR));
            return;
        }
        this.validateTimeField(indexingDryRun);
    }

    protected void validateTimeField(boolean indexingDryRun) {
        String givenTimeField = this.anomalyDetector.getTimeField();
        GetFieldMappingsRequest getMappingsRequest = new GetFieldMappingsRequest();
        getMappingsRequest.indices(this.anomalyDetector.getIndices().toArray(new String[0])).fields(new String[]{givenTimeField});
        getMappingsRequest.indicesOptions(IndicesOptions.strictExpand());
        ActionListener mappingsListener = ActionListener.wrap(getMappingsResponse -> {
            boolean foundField = false;
            Map mappingsByIndex = getMappingsResponse.mappings();
            for (Map mappingsByField : mappingsByIndex.values()) {
                for (Map.Entry field2Metadata : mappingsByField.entrySet()) {
                    Map fieldMap;
                    GetFieldMappingsResponse.FieldMappingMetadata fieldMetadata = (GetFieldMappingsResponse.FieldMappingMetadata)field2Metadata.getValue();
                    if (fieldMetadata == null || (fieldMap = fieldMetadata.sourceAsMap()) == null) continue;
                    for (Object type : fieldMap.values()) {
                        if (!(type instanceof Map)) continue;
                        foundField = true;
                        Map metadataMap = (Map)type;
                        String typeName = (String)metadataMap.get("type");
                        if (typeName.equals("date")) continue;
                        this.listener.onFailure((Exception)new ADValidationException(String.format(Locale.ROOT, CommonErrorMessages.INVALID_TIMESTAMP, givenTimeField), DetectorValidationIssueType.TIMEFIELD_FIELD, ValidationAspect.DETECTOR));
                        return;
                    }
                }
            }
            if (!foundField) {
                this.listener.onFailure((Exception)new ADValidationException(String.format(Locale.ROOT, CommonErrorMessages.NON_EXISTENT_TIMESTAMP, givenTimeField), DetectorValidationIssueType.TIMEFIELD_FIELD, ValidationAspect.DETECTOR));
                return;
            }
            this.prepareAnomalyDetectorIndexing(indexingDryRun);
        }, error -> {
            String message = String.format(Locale.ROOT, "Fail to get the index mapping of %s", this.anomalyDetector.getIndices());
            this.logger.error(message, (Throwable)error);
            this.listener.onFailure((Exception)new IllegalArgumentException(message));
        });
        this.clientUtil.executeWithInjectedSecurity(GetFieldMappingsAction.INSTANCE, getMappingsRequest, this.user, this.client, mappingsListener);
    }

    protected void prepareAnomalyDetectorIndexing(boolean indexingDryRun) {
        if (this.method == RestRequest.Method.PUT) {
            this.handler.getDetectorJob(this.clusterService, this.client, this.detectorId, this.listener, () -> this.updateAnomalyDetector(this.detectorId, indexingDryRun), this.xContentRegistry);
        } else {
            this.createAnomalyDetector(indexingDryRun);
        }
    }

    protected void updateAnomalyDetector(String detectorId, boolean indexingDryRun) {
        GetRequest request = new GetRequest(".opendistro-anomaly-detectors", detectorId);
        this.client.get(request, ActionListener.wrap(response -> this.onGetAnomalyDetectorResponse((GetResponse)response, indexingDryRun, detectorId), exception -> this.listener.onFailure(exception)));
    }

    private void onGetAnomalyDetectorResponse(GetResponse response, boolean indexingDryRun, String detectorId) {
        if (!response.isExists()) {
            this.listener.onFailure((Exception)new OpenSearchStatusException(CommonErrorMessages.FAIL_TO_FIND_DETECTOR_MSG + detectorId, RestStatus.NOT_FOUND, new Object[0]));
            return;
        }
        try (XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(this.xContentRegistry, response.getSourceAsBytesRef());){
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            AnomalyDetector existingDetector = AnomalyDetector.parse(parser, response.getId(), response.getVersion());
            if (!ParseUtils.listEqualsWithoutConsideringOrder(existingDetector.getCategoryField(), this.anomalyDetector.getCategoryField())) {
                this.listener.onFailure((Exception)new OpenSearchStatusException("Can't change detector category field", RestStatus.BAD_REQUEST, new Object[0]));
                return;
            }
            if (!Objects.equals(existingDetector.getResultIndex(), this.anomalyDetector.getResultIndex())) {
                this.listener.onFailure((Exception)new OpenSearchStatusException("Can't change detector result index", RestStatus.BAD_REQUEST, new Object[0]));
                return;
            }
            this.adTaskManager.getAndExecuteOnLatestDetectorLevelTask(detectorId, ADTaskType.HISTORICAL_DETECTOR_TASK_TYPES, adTask -> {
                if (adTask.isPresent() && !((ADTask)adTask.get()).isDone()) {
                    this.listener.onFailure((Exception)new OpenSearchStatusException("Detector is running", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                } else {
                    this.validateExistingDetector(existingDetector, indexingDryRun);
                }
            }, this.transportService, true, this.listener);
        }
        catch (IOException e) {
            String message = "Failed to parse anomaly detector " + detectorId;
            this.logger.error(message, (Throwable)e);
            this.listener.onFailure((Exception)new OpenSearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
    }

    protected void validateExistingDetector(AnomalyDetector existingDetector, boolean indexingDryRun) {
        if (!this.hasCategoryField(existingDetector) && this.hasCategoryField(this.anomalyDetector)) {
            this.validateAgainstExistingMultiEntityAnomalyDetector(this.detectorId, indexingDryRun);
        } else {
            this.validateCategoricalField(this.detectorId, indexingDryRun);
        }
    }

    protected boolean hasCategoryField(AnomalyDetector detector) {
        return detector.getCategoryField() != null && !detector.getCategoryField().isEmpty();
    }

    protected void validateAgainstExistingMultiEntityAnomalyDetector(String detectorId, boolean indexingDryRun) {
        if (this.anomalyDetectionIndices.doesAnomalyDetectorIndexExist()) {
            BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.existsQuery((String)"category_field"));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)query).size(0).timeout(this.requestTimeout);
            SearchRequest searchRequest = new SearchRequest(new String[]{".opendistro-anomaly-detectors"}).source(searchSourceBuilder);
            this.client.search(searchRequest, ActionListener.wrap(response -> this.onSearchMultiEntityAdResponse((SearchResponse)response, detectorId, indexingDryRun), exception -> this.listener.onFailure(exception)));
        } else {
            this.validateCategoricalField(detectorId, indexingDryRun);
        }
    }

    protected void createAnomalyDetector(boolean indexingDryRun) {
        try {
            List<String> categoricalFields = this.anomalyDetector.getCategoryField();
            if (categoricalFields != null && categoricalFields.size() > 0) {
                this.validateAgainstExistingMultiEntityAnomalyDetector(null, indexingDryRun);
            } else if (this.anomalyDetectionIndices.doesAnomalyDetectorIndexExist()) {
                MatchAllQueryBuilder query = QueryBuilders.matchAllQuery();
                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)query).size(0).timeout(this.requestTimeout);
                SearchRequest searchRequest = new SearchRequest(new String[]{".opendistro-anomaly-detectors"}).source(searchSourceBuilder);
                this.client.search(searchRequest, ActionListener.wrap(response -> this.onSearchSingleEntityAdResponse((SearchResponse)response, indexingDryRun), exception -> this.listener.onFailure(exception)));
            } else {
                this.searchAdInputIndices(null, indexingDryRun);
            }
        }
        catch (Exception e) {
            this.listener.onFailure(e);
        }
    }

    protected void onSearchSingleEntityAdResponse(SearchResponse response, boolean indexingDryRun) throws IOException {
        if (response.getHits().getTotalHits().value >= (long)this.maxSingleEntityAnomalyDetectors.intValue()) {
            String errorMsgSingleEntity = String.format(Locale.ROOT, EXCEEDED_MAX_SINGLE_ENTITY_DETECTORS_PREFIX_MSG, this.maxSingleEntityAnomalyDetectors);
            this.logger.error(errorMsgSingleEntity);
            if (indexingDryRun) {
                this.listener.onFailure((Exception)new ADValidationException(errorMsgSingleEntity, DetectorValidationIssueType.GENERAL_SETTINGS, ValidationAspect.DETECTOR));
                return;
            }
            this.listener.onFailure((Exception)new IllegalArgumentException(errorMsgSingleEntity));
        } else {
            this.searchAdInputIndices(null, indexingDryRun);
        }
    }

    protected void onSearchMultiEntityAdResponse(SearchResponse response, String detectorId, boolean indexingDryRun) throws IOException {
        if (response.getHits().getTotalHits().value >= (long)this.maxMultiEntityAnomalyDetectors.intValue()) {
            String errorMsg = String.format(Locale.ROOT, EXCEEDED_MAX_MULTI_ENTITY_DETECTORS_PREFIX_MSG, this.maxMultiEntityAnomalyDetectors);
            this.logger.error(errorMsg);
            if (indexingDryRun) {
                this.listener.onFailure((Exception)new ADValidationException(errorMsg, DetectorValidationIssueType.GENERAL_SETTINGS, ValidationAspect.DETECTOR));
                return;
            }
            this.listener.onFailure((Exception)new IllegalArgumentException(errorMsg));
        } else {
            this.validateCategoricalField(detectorId, indexingDryRun);
        }
    }

    protected void validateCategoricalField(String detectorId, boolean indexingDryRun) {
        List<String> categoryField = this.anomalyDetector.getCategoryField();
        if (categoryField == null) {
            this.searchAdInputIndices(detectorId, indexingDryRun);
            return;
        }
        int maxCategoryFields = NumericSetting.maxCategoricalFields();
        if (categoryField.size() > maxCategoryFields) {
            this.listener.onFailure((Exception)new ADValidationException(CommonErrorMessages.getTooManyCategoricalFieldErr(maxCategoryFields), DetectorValidationIssueType.CATEGORY, ValidationAspect.DETECTOR));
            return;
        }
        String categoryField0 = categoryField.get(0);
        GetFieldMappingsRequest getMappingsRequest = new GetFieldMappingsRequest();
        getMappingsRequest.indices(this.anomalyDetector.getIndices().toArray(new String[0])).fields(categoryField.toArray(new String[0]));
        getMappingsRequest.indicesOptions(IndicesOptions.strictExpand());
        ActionListener mappingsListener = ActionListener.wrap(getMappingsResponse -> {
            boolean foundField = false;
            Map mappingsByIndex = getMappingsResponse.mappings();
            for (Map mappingsByField : mappingsByIndex.values()) {
                for (Map.Entry field2Metadata : mappingsByField.entrySet()) {
                    Map fieldMap;
                    GetFieldMappingsResponse.FieldMappingMetadata fieldMetadata = (GetFieldMappingsResponse.FieldMappingMetadata)field2Metadata.getValue();
                    if (fieldMetadata == null || (fieldMap = fieldMetadata.sourceAsMap()) == null) continue;
                    for (Object type : fieldMap.values()) {
                        if (type == null || !(type instanceof Map)) continue;
                        foundField = true;
                        Map metadataMap = (Map)type;
                        String typeName = (String)metadataMap.get("type");
                        if (typeName.equals("keyword") || typeName.equals("ip")) continue;
                        this.listener.onFailure((Exception)new ADValidationException(CATEGORICAL_FIELD_TYPE_ERR_MSG, DetectorValidationIssueType.CATEGORY, ValidationAspect.DETECTOR));
                        return;
                    }
                }
            }
            if (!foundField) {
                this.listener.onFailure((Exception)new ADValidationException(String.format(Locale.ROOT, CATEGORY_NOT_FOUND_ERR_MSG, categoryField0), DetectorValidationIssueType.CATEGORY, ValidationAspect.DETECTOR));
                return;
            }
            this.searchAdInputIndices(detectorId, indexingDryRun);
        }, error -> {
            String message = String.format(Locale.ROOT, "Fail to get the index mapping of %s", this.anomalyDetector.getIndices());
            this.logger.error(message, (Throwable)error);
            this.listener.onFailure((Exception)new IllegalArgumentException(message));
        });
        this.clientUtil.executeWithInjectedSecurity(GetFieldMappingsAction.INSTANCE, getMappingsRequest, this.user, this.client, mappingsListener);
    }

    protected void searchAdInputIndices(String detectorId, boolean indexingDryRun) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).size(0).timeout(this.requestTimeout);
        SearchRequest searchRequest = new SearchRequest(this.anomalyDetector.getIndices().toArray(new String[0])).source(searchSourceBuilder);
        ActionListener searchResponseListener = ActionListener.wrap(searchResponse -> this.onSearchAdInputIndicesResponse((SearchResponse)searchResponse, detectorId, indexingDryRun), exception -> this.listener.onFailure(exception));
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, searchResponseListener);
    }

    protected void onSearchAdInputIndicesResponse(SearchResponse response, String detectorId, boolean indexingDryRun) throws IOException {
        if (response.getHits().getTotalHits().value == 0L) {
            String errorMsg = NO_DOCS_IN_USER_INDEX_MSG + Arrays.toString(this.anomalyDetector.getIndices().toArray(new String[0]));
            this.logger.error(errorMsg);
            if (indexingDryRun) {
                this.listener.onFailure((Exception)new ADValidationException(errorMsg, DetectorValidationIssueType.INDICES, ValidationAspect.DETECTOR));
                return;
            }
            this.listener.onFailure((Exception)new IllegalArgumentException(errorMsg));
        } else {
            this.validateAnomalyDetectorFeatures(detectorId, indexingDryRun);
        }
    }

    protected void checkADNameExists(String detectorId, boolean indexingDryRun) throws IOException {
        if (this.anomalyDetectionIndices.doesAnomalyDetectorIndexExist()) {
            BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"name.keyword", (String)this.anomalyDetector.getName()));
            if (StringUtils.isNotBlank((String)detectorId)) {
                boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)detectorId));
            }
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder).timeout(this.requestTimeout);
            SearchRequest searchRequest = new SearchRequest(new String[]{".opendistro-anomaly-detectors"}).source(searchSourceBuilder);
            this.client.search(searchRequest, ActionListener.wrap(searchResponse -> this.onSearchADNameResponse((SearchResponse)searchResponse, detectorId, this.anomalyDetector.getName(), indexingDryRun), exception -> this.listener.onFailure(exception)));
        } else {
            this.tryIndexingAnomalyDetector(indexingDryRun);
        }
    }

    protected void onSearchADNameResponse(SearchResponse response, String detectorId, String name, boolean indexingDryRun) throws IOException {
        if (response.getHits().getTotalHits().value > 0L) {
            String errorMsg = String.format(Locale.ROOT, DUPLICATE_DETECTOR_MSG, name, Arrays.stream(response.getHits().getHits()).map(hit -> hit.getId()).collect(Collectors.toList()));
            this.logger.warn(errorMsg);
            this.listener.onFailure((Exception)new ADValidationException(errorMsg, DetectorValidationIssueType.NAME, ValidationAspect.DETECTOR));
        } else {
            this.tryIndexingAnomalyDetector(indexingDryRun);
        }
    }

    protected void tryIndexingAnomalyDetector(boolean indexingDryRun) throws IOException {
        if (!indexingDryRun) {
            this.indexAnomalyDetector(this.detectorId);
        } else {
            this.finishDetectorValidationOrContinueToModelValidation();
        }
    }

    protected Set<ValidationAspect> getValidationTypes(String validationType) {
        if (StringUtils.isBlank((String)validationType)) {
            return DEFAULT_VALIDATION_ASPECTS;
        }
        HashSet<String> typesInRequest = new HashSet<String>(Arrays.asList(validationType.split(",")));
        return ValidationAspect.getNames((Collection<String>)Sets.intersection(RestValidateAnomalyDetectorAction.ALL_VALIDATION_ASPECTS_STRS, typesInRequest));
    }

    protected void finishDetectorValidationOrContinueToModelValidation() {
        this.logger.info("Skipping indexing detector. No blocking issue found so far.");
        if (!this.getValidationTypes(this.validationType).contains(ValidationAspect.MODEL)) {
            this.listener.onResponse(null);
        } else {
            ModelValidationActionHandler modelValidationActionHandler = new ModelValidationActionHandler(this.clusterService, this.client, this.clientUtil, this.listener, this.anomalyDetector, this.requestTimeout, this.xContentRegistry, this.searchFeatureDao, this.validationType, this.clock, this.settings, this.user);
            modelValidationActionHandler.checkIfMultiEntityDetector();
        }
    }

    protected void indexAnomalyDetector(final String detectorId) throws IOException {
        final AnomalyDetector detector = new AnomalyDetector(this.anomalyDetector.getDetectorId(), this.anomalyDetector.getVersion(), this.anomalyDetector.getName(), this.anomalyDetector.getDescription(), this.anomalyDetector.getTimeField(), this.anomalyDetector.getIndices(), this.anomalyDetector.getFeatureAttributes(), this.anomalyDetector.getFilterQuery(), this.anomalyDetector.getDetectionInterval(), this.anomalyDetector.getWindowDelay(), this.anomalyDetector.getShingleSize(), this.anomalyDetector.getUiMetadata(), this.anomalyDetector.getSchemaVersion(), Instant.now(), this.anomalyDetector.getCategoryField(), this.user, this.anomalyDetector.getResultIndex());
        IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opendistro-anomaly-detectors").setRefreshPolicy(this.refreshPolicy)).source(detector.toXContent(XContentFactory.jsonBuilder(), (ToXContent.Params)RestHandlerUtils.XCONTENT_WITH_TYPE)).setIfSeqNo(this.seqNo.longValue()).setIfPrimaryTerm(this.primaryTerm.longValue()).timeout(this.requestTimeout);
        if (StringUtils.isNotBlank((String)detectorId)) {
            indexRequest.id(detectorId);
        }
        this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse indexResponse) {
                String errorMsg = AbstractAnomalyDetectorActionHandler.this.checkShardsFailure(indexResponse);
                if (errorMsg != null) {
                    AbstractAnomalyDetectorActionHandler.this.listener.onFailure((Exception)new OpenSearchStatusException(errorMsg, indexResponse.status(), new Object[0]));
                    return;
                }
                AbstractAnomalyDetectorActionHandler.this.listener.onResponse((Object)new IndexAnomalyDetectorResponse(indexResponse.getId(), indexResponse.getVersion(), indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), detector, RestStatus.CREATED));
            }

            public void onFailure(Exception e) {
                AbstractAnomalyDetectorActionHandler.this.logger.warn("Failed to update detector", (Throwable)e);
                if (e.getMessage() != null && e.getMessage().contains("version conflict")) {
                    AbstractAnomalyDetectorActionHandler.this.listener.onFailure((Exception)new IllegalArgumentException("There was a problem updating the historical detector:[" + detectorId + "]"));
                } else {
                    AbstractAnomalyDetectorActionHandler.this.listener.onFailure(e);
                }
            }
        });
    }

    protected void onCreateMappingsResponse(CreateIndexResponse response, boolean indexingDryRun) throws IOException {
        if (response.isAcknowledged()) {
            this.logger.info("Created {} with mappings.", (Object)".opendistro-anomaly-detectors");
            this.prepareAnomalyDetectorIndexing(indexingDryRun);
        } else {
            this.logger.warn("Created {} with mappings call not acknowledged.", (Object)".opendistro-anomaly-detectors");
            this.listener.onFailure((Exception)new OpenSearchStatusException("Created .opendistro-anomaly-detectorswith mappings call not acknowledged.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
    }

    protected String checkShardsFailure(IndexResponse response) {
        StringBuilder failureReasons = new StringBuilder();
        if (response.getShardInfo().getFailed() > 0) {
            for (ReplicationResponse.ShardInfo.Failure failure : response.getShardInfo().getFailures()) {
                failureReasons.append(failure);
            }
            return failureReasons.toString();
        }
        return null;
    }

    protected void validateAnomalyDetectorFeatures(String detectorId, boolean indexingDryRun) throws IOException {
        if (this.anomalyDetector != null && (this.anomalyDetector.getFeatureAttributes() == null || this.anomalyDetector.getFeatureAttributes().isEmpty())) {
            this.checkADNameExists(detectorId, indexingDryRun);
            return;
        }
        String error = RestHandlerUtils.checkAnomalyDetectorFeaturesSyntax(this.anomalyDetector, this.maxAnomalyFeatures);
        if (StringUtils.isNotBlank((String)error)) {
            if (indexingDryRun) {
                this.listener.onFailure((Exception)new ADValidationException(error, DetectorValidationIssueType.FEATURE_ATTRIBUTES, ValidationAspect.DETECTOR));
                return;
            }
            this.listener.onFailure((Exception)new OpenSearchStatusException(error, RestStatus.BAD_REQUEST, new Object[0]));
            return;
        }
        ActionListener validateFeatureQueriesListener = ActionListener.wrap(response -> this.checkADNameExists(detectorId, indexingDryRun), exception -> this.listener.onFailure((Exception)new ADValidationException(exception.getMessage(), DetectorValidationIssueType.FEATURE_ATTRIBUTES, ValidationAspect.DETECTOR)));
        MultiResponsesDelegateActionListener multiFeatureQueriesResponseListener = new MultiResponsesDelegateActionListener(validateFeatureQueriesListener, this.anomalyDetector.getFeatureAttributes().size(), String.format(Locale.ROOT, "Validation failed for feature(s) of detector %s", this.anomalyDetector.getName()), false);
        for (Feature feature : this.anomalyDetector.getFeatureAttributes()) {
            SearchSourceBuilder ssb = new SearchSourceBuilder().size(1).query((QueryBuilder)QueryBuilders.matchAllQuery());
            AggregatorFactories.Builder internalAgg = ParseUtils.parseAggregators(feature.getAggregation().toString(), this.xContentRegistry, feature.getId());
            ssb.aggregation((AggregationBuilder)internalAgg.getAggregatorFactories().iterator().next());
            SearchRequest searchRequest = new SearchRequest().indices(this.anomalyDetector.getIndices().toArray(new String[0])).source(ssb);
            ActionListener searchResponseListener = ActionListener.wrap(response -> {
                Optional<double[]> aggFeatureResult = this.searchFeatureDao.parseResponse((SearchResponse)response, Arrays.asList(feature.getId()));
                if (aggFeatureResult.isPresent()) {
                    multiFeatureQueriesResponseListener.onResponse(new MergeableList<Optional>(new ArrayList<Optional>(Arrays.asList(aggFeatureResult))));
                } else {
                    String errorMessage = "Feature has an invalid query returning empty aggregated data: " + feature.getName();
                    this.logger.error(errorMessage);
                    multiFeatureQueriesResponseListener.onFailure((Exception)new OpenSearchStatusException(errorMessage, RestStatus.BAD_REQUEST, new Object[0]));
                }
            }, e -> {
                String errorMessage = RestHandlerUtils.isExceptionCausedByInvalidQuery(e) ? "Feature has an invalid query causing a runtime exception: " + feature.getName() : "Feature has an unknown exception caught while executing the feature query: " + feature.getName();
                this.logger.error(errorMessage, (Throwable)e);
                multiFeatureQueriesResponseListener.onFailure((Exception)new OpenSearchStatusException(errorMessage, RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]));
            });
            this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, searchResponseListener);
        }
    }
}

