/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class RCFResultRequest
extends ActionRequest
implements ToXContentObject {
    private String adID;
    private String modelID;
    private double[] features;
    public static final String INVALID_FEATURE_MSG = "feature vector is empty";

    public RCFResultRequest(StreamInput in) throws IOException {
        super(in);
        this.adID = in.readString();
        this.modelID = in.readString();
        int size = in.readVInt();
        this.features = new double[size];
        for (int i = 0; i < size; ++i) {
            this.features[i] = in.readDouble();
        }
    }

    public RCFResultRequest(String adID, String modelID, double[] features) {
        this.adID = adID;
        this.modelID = modelID;
        this.features = features;
    }

    public double[] getFeatures() {
        return this.features;
    }

    public String getAdID() {
        return this.adID;
    }

    public String getModelID() {
        return this.modelID;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.adID);
        out.writeString(this.modelID);
        out.writeVInt(this.features.length);
        for (double feature : this.features) {
            out.writeDouble(feature);
        }
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.features == null || this.features.length == 0) {
            validationException = ValidateActions.addValidationError((String)INVALID_FEATURE_MSG, validationException);
        }
        if (Strings.isEmpty((CharSequence)this.adID)) {
            validationException = ValidateActions.addValidationError((String)"AD ID is missing", (ActionRequestValidationException)validationException);
        }
        if (Strings.isEmpty((CharSequence)this.modelID)) {
            validationException = ValidateActions.addValidationError((String)"Model ID is missing", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("adID", this.adID);
        builder.field("model_id", this.modelID);
        builder.startArray("features");
        for (double feature : this.features) {
            builder.value(feature);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }
}

