# `MD051` - Link fragments should be valid

Tags: `links`

Aliases: `link-fragments`

Fixable: Some violations can be fixed by tooling

This rule is triggered when a link fragment does not match any of the fragments
that are automatically generated for headings in a document:

```markdown
# Title

[Link](#fragment)
```

To fix this issue, change the link fragment to reference an existing heading:

```markdown
# Title

[Link](#title)
```

Alternatively, an HTML `a` tag with an `id` or a `name` attribute can be used to
define a fragment:

```markdown
<a id="bookmark"></a>

[Link](#bookmark)
```

An `a` tag can be useful in scenarios where a heading is not appropriate or for
control over the text of the fragment identifier.

Rationale: [GitHub section links][github-section-links] are created
automatically for every heading when Markdown content is displayed on GitHub.
This makes it easy to link directly to different sections within a document.
However, section links change if headings are renamed or removed. This rule
helps identify broken section links within a document.

Section links are **not** part of the CommonMark specification. This rule
enforces the [GitHub heading algorithm][github-heading-algorithm] which is:
convert heading to lowercase, remove punctuation, convert spaces to dashes,
append an incrementing integer as needed for uniqueness.

[github-section-links]: https://docs.github.com/en/get-started/writing-on-github/getting-started-with-writing-and-formatting-on-github/basic-writing-and-formatting-syntax#section-links
[github-heading-algorithm]: https://github.com/gjtorikian/html-pipeline/blob/f13a1534cb650ba17af400d1acd3a22c28004c09/lib/html/pipeline/toc_filter.rb
