"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createOnBrushEndCaller = void 0;
var __1 = require("../../..");
var constants_1 = require("../../../../specs/constants");
var create_selector_1 = require("../../../../state/create_selector");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var common_1 = require("../../../../utils/common");
var events_1 = require("../../../../utils/events");
var common_2 = require("../utils/common");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var compute_small_multiple_scales_1 = require("./compute_small_multiple_scales");
var get_brush_area_1 = require("./get_brush_area");
var get_computed_scales_1 = require("./get_computed_scales");
var is_brush_available_1 = require("./is_brush_available");
var is_histogram_mode_enabled_1 = require("./is_histogram_mode_enabled");
var getLastDragSelector = function (state) { return state.interactions.pointer.lastDrag; };
function createOnBrushEndCaller() {
    var prevProps = null;
    var selector = null;
    return function (state) {
        if (selector === null && state.chartType === __1.ChartType.XYAxis) {
            if (!is_brush_available_1.isBrushAvailableSelector(state)) {
                selector = null;
                prevProps = null;
                return;
            }
            selector = create_selector_1.createCustomCachedSelector([
                getLastDragSelector,
                get_settings_specs_1.getSettingsSpecSelector,
                get_computed_scales_1.getComputedScalesSelector,
                compute_chart_dimensions_1.computeChartDimensionsSelector,
                is_histogram_mode_enabled_1.isHistogramModeEnabledSelector,
                compute_small_multiple_scales_1.computeSmallMultipleScalesSelector,
            ], function (lastDrag, _a, computedScales, _b, histogramMode, smallMultipleScales) {
                var onBrushEnd = _a.onBrushEnd, rotation = _a.rotation, brushAxis = _a.brushAxis, minBrushDelta = _a.minBrushDelta, roundHistogramBrushValues = _a.roundHistogramBrushValues, allowBrushingLastHistogramBucket = _a.allowBrushingLastHistogramBucket;
                var chartDimensions = _b.chartDimensions;
                var nextProps = {
                    lastDrag: lastDrag,
                    onBrushEnd: onBrushEnd,
                };
                if (lastDrag !== null && events_1.hasDragged(prevProps, nextProps) && onBrushEnd) {
                    var brushArea = {};
                    var yScales = computedScales.yScales, xScale = computedScales.xScale;
                    if (brushAxis === constants_1.BrushAxis.X || brushAxis === constants_1.BrushAxis.Both) {
                        brushArea.x = getXBrushExtent(chartDimensions, lastDrag, rotation, histogramMode, xScale, smallMultipleScales, minBrushDelta, roundHistogramBrushValues, allowBrushingLastHistogramBucket);
                    }
                    if (brushAxis === constants_1.BrushAxis.Y || brushAxis === constants_1.BrushAxis.Both) {
                        brushArea.y = getYBrushExtents(chartDimensions, lastDrag, rotation, yScales, smallMultipleScales, minBrushDelta);
                    }
                    if (brushArea.x !== undefined || brushArea.y !== undefined) {
                        onBrushEnd(brushArea);
                    }
                }
                prevProps = nextProps;
            });
        }
        if (selector) {
            selector(state);
        }
    };
}
exports.createOnBrushEndCaller = createOnBrushEndCaller;
function scalePanelPointsToPanelCoordinates(scaleXPoint, _a) {
    var start = _a.start, end = _a.end, vPanelStart = _a.vPanelStart, hPanelStart = _a.hPanelStart, vPanelHeight = _a.vPanelHeight, hPanelWidth = _a.hPanelWidth;
    var startPos = scaleXPoint ? start.x - hPanelStart : start.y - vPanelStart;
    var endPos = scaleXPoint ? end.x - hPanelStart : end.y - vPanelStart;
    var panelMax = scaleXPoint ? hPanelWidth : vPanelHeight;
    return {
        minPos: Math.min(startPos, endPos),
        maxPos: Math.max(startPos, endPos),
        panelMax: panelMax,
    };
}
function getXBrushExtent(chartDimensions, lastDrag, rotation, histogramMode, xScale, smallMultipleScales, minBrushDelta, roundHistogramBrushValues, allowBrushingLastHistogramBucket) {
    var isXHorizontal = !common_2.isVerticalRotation(rotation);
    var scaledPanelPoints = getMinMaxPos(chartDimensions, lastDrag, smallMultipleScales, isXHorizontal);
    var minPos = scaledPanelPoints.minPos, maxPos = scaledPanelPoints.maxPos;
    if (rotation === -90 || rotation === 180) {
        minPos = scaledPanelPoints.panelMax - minPos;
        maxPos = scaledPanelPoints.panelMax - maxPos;
    }
    if (minBrushDelta !== undefined ? Math.abs(maxPos - minPos) < minBrushDelta : maxPos === minPos) {
        return;
    }
    var offset = histogramMode ? 0 : -(xScale.bandwidth + xScale.bandwidthPadding) / 2;
    var invertValue = roundHistogramBrushValues
        ? function (value) { var _a; return (_a = xScale.invertWithStep(value, xScale.domain)) === null || _a === void 0 ? void 0 : _a.value; }
        : function (value) { return xScale.invert(value); };
    var minPosScaled = invertValue(minPos + offset);
    var maxPosScaled = invertValue(maxPos + offset);
    var maxDomainValue = xScale.domain[1] + (allowBrushingLastHistogramBucket ? xScale.minInterval : 0);
    var minValue = common_1.minValueWithLowerLimit(minPosScaled, maxPosScaled, xScale.domain[0]);
    var maxValue = common_1.maxValueWithUpperLimit(minPosScaled, maxPosScaled, maxDomainValue);
    return [minValue, maxValue];
}
function getMinMaxPos(chartDimensions, lastDrag, smallMultipleScales, scaleXPoint) {
    var panelPoints = getPanelPoints(chartDimensions, lastDrag, smallMultipleScales);
    return scalePanelPointsToPanelCoordinates(scaleXPoint, panelPoints);
}
function getPanelPoints(chartDimensions, lastDrag, smallMultipleScales) {
    var plotStartPointPx = get_brush_area_1.getPlotAreaRestrictedPoint(lastDrag.start.position, chartDimensions);
    var plotEndPointPx = get_brush_area_1.getPlotAreaRestrictedPoint(lastDrag.end.position, chartDimensions);
    return get_brush_area_1.getPointsConstraintToSinglePanel(plotStartPointPx, plotEndPointPx, smallMultipleScales);
}
function getYBrushExtents(chartDimensions, lastDrag, rotation, yScales, smallMultipleScales, minBrushDelta) {
    var yValues = [];
    yScales.forEach(function (yScale, groupId) {
        var isXVertical = common_2.isVerticalRotation(rotation);
        var scaledPanelPoints = getMinMaxPos(chartDimensions, lastDrag, smallMultipleScales, isXVertical);
        var minPos = scaledPanelPoints.minPos, maxPos = scaledPanelPoints.maxPos;
        if (rotation === 90 || rotation === 180) {
            minPos = scaledPanelPoints.panelMax - minPos;
            maxPos = scaledPanelPoints.panelMax - maxPos;
        }
        if (minBrushDelta !== undefined ? Math.abs(maxPos - minPos) < minBrushDelta : maxPos === minPos) {
            return;
        }
        var minPosScaled = yScale.invert(minPos);
        var maxPosScaled = yScale.invert(maxPos);
        var minValue = common_1.minValueWithLowerLimit(minPosScaled, maxPosScaled, yScale.domain[0]);
        var maxValue = common_1.maxValueWithUpperLimit(minPosScaled, maxPosScaled, yScale.domain[1]);
        yValues.push({ extent: [minValue, maxValue], groupId: groupId });
    });
    return yValues.length === 0 ? undefined : yValues;
}
//# sourceMappingURL=on_brush_end_caller.js.map