/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.components;

import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaDeprecatedAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaRetentionAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaTargetAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaAnnotationMapper {
    @NotNull
    public static final JavaAnnotationMapper INSTANCE = new JavaAnnotationMapper();
    @NotNull
    private static final Name DEPRECATED_ANNOTATION_MESSAGE;
    @NotNull
    private static final Name TARGET_ANNOTATION_ALLOWED_TARGETS;
    @NotNull
    private static final Name RETENTION_ANNOTATION_VALUE;
    @NotNull
    private static final Map<FqName, FqName> kotlinToJavaNameMap;
    @NotNull
    private static final Map<FqName, FqName> javaToKotlinNameMap;

    private JavaAnnotationMapper() {
    }

    @NotNull
    public final Name getDEPRECATED_ANNOTATION_MESSAGE$descriptors_jvm() {
        return DEPRECATED_ANNOTATION_MESSAGE;
    }

    @NotNull
    public final Name getTARGET_ANNOTATION_ALLOWED_TARGETS$descriptors_jvm() {
        return TARGET_ANNOTATION_ALLOWED_TARGETS;
    }

    @NotNull
    public final Name getRETENTION_ANNOTATION_VALUE$descriptors_jvm() {
        return RETENTION_ANNOTATION_VALUE;
    }

    @Nullable
    public final AnnotationDescriptor mapOrResolveJavaAnnotation(@NotNull JavaAnnotation annotation, @NotNull LazyJavaResolverContext c, boolean isFreshlySupportedAnnotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        ClassId classId = annotation.getClassId();
        return Intrinsics.areEqual((Object)classId, (Object)ClassId.topLevel(JvmAnnotationNames.TARGET_ANNOTATION)) ? (AnnotationDescriptor)new JavaTargetAnnotationDescriptor(annotation, c) : (Intrinsics.areEqual((Object)classId, (Object)ClassId.topLevel(JvmAnnotationNames.RETENTION_ANNOTATION)) ? (AnnotationDescriptor)new JavaRetentionAnnotationDescriptor(annotation, c) : (Intrinsics.areEqual((Object)classId, (Object)ClassId.topLevel(JvmAnnotationNames.REPEATABLE_ANNOTATION)) ? (AnnotationDescriptor)new JavaAnnotationDescriptor(c, annotation, StandardNames.FqNames.repeatable) : (Intrinsics.areEqual((Object)classId, (Object)ClassId.topLevel(JvmAnnotationNames.DOCUMENTED_ANNOTATION)) ? (AnnotationDescriptor)new JavaAnnotationDescriptor(c, annotation, StandardNames.FqNames.mustBeDocumented) : (Intrinsics.areEqual((Object)classId, (Object)ClassId.topLevel(JvmAnnotationNames.DEPRECATED_ANNOTATION)) ? null : (AnnotationDescriptor)new LazyJavaAnnotationDescriptor(c, annotation, isFreshlySupportedAnnotation)))));
    }

    public static /* synthetic */ AnnotationDescriptor mapOrResolveJavaAnnotation$default(JavaAnnotationMapper javaAnnotationMapper, JavaAnnotation javaAnnotation, LazyJavaResolverContext lazyJavaResolverContext, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return javaAnnotationMapper.mapOrResolveJavaAnnotation(javaAnnotation, lazyJavaResolverContext, bl);
    }

    @Nullable
    public final AnnotationDescriptor findMappedJavaAnnotation(@NotNull FqName kotlinName, @NotNull JavaAnnotationOwner annotationOwner, @NotNull LazyJavaResolverContext c) {
        AnnotationDescriptor annotationDescriptor;
        FqName fqName2;
        FqName fqName3;
        Intrinsics.checkNotNullParameter((Object)kotlinName, (String)"kotlinName");
        Intrinsics.checkNotNullParameter((Object)annotationOwner, (String)"annotationOwner");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (Intrinsics.areEqual((Object)kotlinName, (Object)StandardNames.FqNames.deprecated)) {
            fqName3 = JvmAnnotationNames.DEPRECATED_ANNOTATION;
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"DEPRECATED_ANNOTATION");
            JavaAnnotation javaAnnotation = annotationOwner.findAnnotation(fqName3);
            if (javaAnnotation != null || annotationOwner.isDeprecatedInJavaDoc()) {
                return new JavaDeprecatedAnnotationDescriptor(javaAnnotation, c);
            }
        }
        if ((fqName2 = kotlinToJavaNameMap.get(kotlinName)) == null) {
            annotationDescriptor = null;
        } else {
            fqName3 = fqName2;
            boolean bl = false;
            boolean bl2 = false;
            FqName javaName = fqName3;
            boolean bl3 = false;
            JavaAnnotation javaAnnotation = annotationOwner.findAnnotation(javaName);
            if (javaAnnotation == null) {
                annotationDescriptor = null;
            } else {
                JavaAnnotation javaAnnotation2 = javaAnnotation;
                boolean bl4 = false;
                boolean bl5 = false;
                JavaAnnotation annotation = javaAnnotation2;
                boolean bl6 = false;
                annotationDescriptor = JavaAnnotationMapper.mapOrResolveJavaAnnotation$default(this, annotation, c, false, 4, null);
            }
        }
        return annotationDescriptor;
    }

    static {
        Pair[] pairArray = Name.identifier("message");
        Intrinsics.checkNotNullExpressionValue((Object)pairArray, (String)"identifier(\"message\")");
        DEPRECATED_ANNOTATION_MESSAGE = pairArray;
        pairArray = Name.identifier("allowedTargets");
        Intrinsics.checkNotNullExpressionValue((Object)pairArray, (String)"identifier(\"allowedTargets\")");
        TARGET_ANNOTATION_ALLOWED_TARGETS = pairArray;
        pairArray = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue((Object)pairArray, (String)"identifier(\"value\")");
        RETENTION_ANNOTATION_VALUE = pairArray;
        pairArray = new Pair[]{TuplesKt.to((Object)StandardNames.FqNames.target, (Object)JvmAnnotationNames.TARGET_ANNOTATION), TuplesKt.to((Object)StandardNames.FqNames.retention, (Object)JvmAnnotationNames.RETENTION_ANNOTATION), TuplesKt.to((Object)StandardNames.FqNames.repeatable, (Object)JvmAnnotationNames.REPEATABLE_ANNOTATION), TuplesKt.to((Object)StandardNames.FqNames.mustBeDocumented, (Object)JvmAnnotationNames.DOCUMENTED_ANNOTATION)};
        kotlinToJavaNameMap = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)JvmAnnotationNames.TARGET_ANNOTATION, (Object)StandardNames.FqNames.target), TuplesKt.to((Object)JvmAnnotationNames.RETENTION_ANNOTATION, (Object)StandardNames.FqNames.retention), TuplesKt.to((Object)JvmAnnotationNames.DEPRECATED_ANNOTATION, (Object)StandardNames.FqNames.deprecated), TuplesKt.to((Object)JvmAnnotationNames.REPEATABLE_ANNOTATION, (Object)StandardNames.FqNames.repeatable), TuplesKt.to((Object)JvmAnnotationNames.DOCUMENTED_ANNOTATION, (Object)StandardNames.FqNames.mustBeDocumented)};
        javaToKotlinNameMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

