/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.alerting.model.action.AlertCategory;
import org.opensearch.commons.alerting.model.action.PerAlertActionScope;
import org.opensearch.commons.alerting.model.action.PerExecutionActionScope;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.core.xcontent.XContentParser;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00052\u00020\u0001:\u0002\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&\u0082\u0001\u0002\u0007\b\u00a8\u0006\t"}, d2={"Lorg/opensearch/commons/alerting/model/action/ActionExecutionScope;", "Lorg/opensearch/commons/notifications/model/BaseModel;", "()V", "getExecutionScope", "Lorg/opensearch/commons/alerting/model/action/ActionExecutionScope$Type;", "Companion", "Type", "Lorg/opensearch/commons/alerting/model/action/PerAlertActionScope;", "Lorg/opensearch/commons/alerting/model/action/PerExecutionActionScope;", "common-utils"})
public abstract class ActionExecutionScope
implements BaseModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PER_ALERT_FIELD = "per_alert";
    @NotNull
    public static final String PER_EXECUTION_FIELD = "per_execution";
    @NotNull
    public static final String ACTIONABLE_ALERTS_FIELD = "actionable_alerts";

    private ActionExecutionScope() {
    }

    @NotNull
    public abstract Type getExecutionScope();

    @JvmStatic
    @NotNull
    public static final ActionExecutionScope parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @JvmStatic
    @NotNull
    public static final ActionExecutionScope readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    public /* synthetic */ ActionExecutionScope(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/commons/alerting/model/action/ActionExecutionScope$Type;", "", "(Ljava/lang/String;I)V", "PER_ALERT", "PER_EXECUTION", "common-utils"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type PER_ALERT = new Type();
        public static final /* enum */ Type PER_EXECUTION = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.PER_ALERT, Type.PER_EXECUTION};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/commons/alerting/model/action/ActionExecutionScope$Companion;", "", "()V", "ACTIONABLE_ALERTS_FIELD", "", "PER_ALERT_FIELD", "PER_EXECUTION_FIELD", "parse", "Lorg/opensearch/commons/alerting/model/action/ActionExecutionScope;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "readFrom", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final ActionExecutionScope parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Type type = null;
            ActionExecutionScope actionExecutionScope = null;
            Set alertFilter = new LinkedHashSet();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                if (type != null) {
                    throw new IllegalArgumentException("You can only specify one type of action execution scope.");
                }
                String string = fieldName;
                if (Intrinsics.areEqual((Object)string, (Object)ActionExecutionScope.PER_ALERT_FIELD)) {
                    type = Type.PER_ALERT;
                    while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                        String perAlertFieldName = xcp.currentName();
                        xcp.nextToken();
                        if (Intrinsics.areEqual((Object)perAlertFieldName, (Object)ActionExecutionScope.ACTIONABLE_ALERTS_FIELD)) {
                            void $this$mapTo$iv$iv;
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            AlertCategory[] $this$map$iv = AlertCategory.values();
                            boolean $i$f$map = false;
                            AlertCategory[] alertCategoryArray = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                            boolean $i$f$mapTo = false;
                            for (void item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                void var18_20 = item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(it.toString());
                            }
                            List allowedCategories = (List)destination$iv$iv;
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                String alertCategory = xcp.text();
                                if (!allowedCategories.contains(alertCategory)) {
                                    throw new IllegalStateException("Actionable alerts should be one of " + allowedCategories);
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)alertCategory, (String)"alertCategory");
                                alertFilter.add(AlertCategory.valueOf(alertCategory));
                            }
                            continue;
                        }
                        throw new IllegalArgumentException("Invalid field [" + perAlertFieldName + "] found in per alert action execution scope.");
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)ActionExecutionScope.PER_EXECUTION_FIELD)) {
                    type = Type.PER_EXECUTION;
                    while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                    }
                    continue;
                }
                throw new IllegalArgumentException("Invalid field [" + fieldName + "] found in action execution scope.");
            }
            if (type == Type.PER_ALERT) {
                actionExecutionScope = new PerAlertActionScope(alertFilter);
            } else if (type == Type.PER_EXECUTION) {
                actionExecutionScope = new PerExecutionActionScope();
            }
            ActionExecutionScope actionExecutionScope2 = actionExecutionScope;
            if (actionExecutionScope2 == null) {
                boolean bl = false;
                String string = "Action execution scope is null.";
                throw new IllegalArgumentException(string.toString());
            }
            return actionExecutionScope2;
        }

        @JvmStatic
        @NotNull
        public final ActionExecutionScope readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            Type type = (Type)sin.readEnum(Type.class);
            return type == Type.PER_ALERT ? (ActionExecutionScope)new PerAlertActionScope(sin) : (ActionExecutionScope)new PerExecutionActionScope(sin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

