/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.dataframe;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.dataframe.ColumnType;

public interface ColumnValue
extends Writeable,
ToXContentObject {
    public ColumnType columnType();

    public Object getValue();

    default public short shortValue() {
        throw new RuntimeException("the value isn't Short type");
    }

    default public int intValue() {
        throw new RuntimeException("the value isn't Integer type");
    }

    default public long longValue() {
        throw new RuntimeException("the value isn't Long type");
    }

    default public String stringValue() {
        throw new RuntimeException("the value isn't String type");
    }

    default public double doubleValue() {
        throw new RuntimeException("the value isn't Double type");
    }

    default public float floatValue() {
        throw new RuntimeException("the value isn't Float type");
    }

    default public boolean booleanValue() {
        throw new RuntimeException("the value isn't Boolean type");
    }

    default public void toXContent(XContentBuilder builder) throws IOException {
        this.toXContent(builder, EMPTY_PARAMS);
    }

    default public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("column_type", (Object)this.columnType());
        if (this.columnType() != ColumnType.NULL) {
            builder.field("value", this.getValue());
        }
        builder.endObject();
        return builder;
    }

    default public boolean equals(ColumnValue other) {
        if (this == other) {
            return true;
        }
        if (this.columnType() != other.columnType()) {
            return false;
        }
        return Objects.equals(this.getValue(), other.getValue());
    }
}

