/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.plugin;

import com.alibaba.druid.sql.parser.ParserException;
import com.google.common.collect.ImmutableList;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.Client;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.inject.Injector;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.common.utils.QueryContext;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.legacy.antlr.OpenSearchLegacySqlAnalyzer;
import org.opensearch.sql.legacy.antlr.SqlAnalysisConfig;
import org.opensearch.sql.legacy.antlr.SqlAnalysisException;
import org.opensearch.sql.legacy.antlr.semantic.types.Type;
import org.opensearch.sql.legacy.cursor.CursorType;
import org.opensearch.sql.legacy.domain.ColumnTypeProvider;
import org.opensearch.sql.legacy.domain.QueryActionRequest;
import org.opensearch.sql.legacy.esdomain.LocalClusterState;
import org.opensearch.sql.legacy.exception.SQLFeatureDisabledException;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.executor.ActionRequestRestExecutorFactory;
import org.opensearch.sql.legacy.executor.Format;
import org.opensearch.sql.legacy.executor.RestExecutor;
import org.opensearch.sql.legacy.executor.cursor.CursorActionRequestRestExecutorFactory;
import org.opensearch.sql.legacy.executor.cursor.CursorAsyncRestExecutor;
import org.opensearch.sql.legacy.executor.format.ErrorMessageFactory;
import org.opensearch.sql.legacy.metrics.MetricName;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.sql.legacy.plugin.RestSQLQueryAction;
import org.opensearch.sql.legacy.plugin.SearchDao;
import org.opensearch.sql.legacy.query.QueryAction;
import org.opensearch.sql.legacy.request.SqlRequest;
import org.opensearch.sql.legacy.request.SqlRequestFactory;
import org.opensearch.sql.legacy.request.SqlRequestParam;
import org.opensearch.sql.legacy.rewriter.matchtoterm.VerificationException;
import org.opensearch.sql.legacy.utils.JsonPrettyFormatter;
import org.opensearch.sql.legacy.utils.QueryDataAnonymizer;
import org.opensearch.sql.sql.domain.SQLQueryRequest;

public class RestSqlAction
extends BaseRestHandler {
    private static final Logger LOG = LogManager.getLogger(RestSqlAction.class);
    private final boolean allowExplicitIndex;
    private static final Predicate<String> CONTAINS_SUBQUERY = Pattern.compile("\\(\\s*select ").asPredicate();
    public static final String QUERY_API_ENDPOINT = "/_plugins/_sql";
    public static final String EXPLAIN_API_ENDPOINT = "/_plugins/_sql/_explain";
    public static final String CURSOR_CLOSE_ENDPOINT = "/_plugins/_sql/close";
    public static final String LEGACY_QUERY_API_ENDPOINT = "/_opendistro/_sql";
    public static final String LEGACY_EXPLAIN_API_ENDPOINT = "/_opendistro/_sql/_explain";
    public static final String LEGACY_CURSOR_CLOSE_ENDPOINT = "/_opendistro/_sql/close";
    private final RestSQLQueryAction newSqlQueryHandler;

    public RestSqlAction(Settings settings, Injector injector) {
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
        this.newSqlQueryHandler = new RestSQLQueryAction(injector);
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return ImmutableList.of((Object)new RestHandler.ReplacedRoute(RestRequest.Method.POST, QUERY_API_ENDPOINT, RestRequest.Method.POST, LEGACY_QUERY_API_ENDPOINT), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.POST, EXPLAIN_API_ENDPOINT, RestRequest.Method.POST, LEGACY_EXPLAIN_API_ENDPOINT), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.POST, CURSOR_CLOSE_ENDPOINT, RestRequest.Method.POST, LEGACY_CURSOR_CLOSE_ENDPOINT));
    }

    public String getName() {
        return "sql_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        Metrics.getInstance().getNumericalMetric(MetricName.REQ_TOTAL).increment();
        Metrics.getInstance().getNumericalMetric(MetricName.REQ_COUNT_TOTAL).increment();
        QueryContext.addRequestId();
        try {
            if (!this.isSQLFeatureEnabled()) {
                throw new SQLFeatureDisabledException("Either plugins.sql.enabled or rest.action.multi.allow_explicit_index setting is false");
            }
            SqlRequest sqlRequest = SqlRequestFactory.getSqlRequest(request);
            if (RestSqlAction.isLegacyCursor(sqlRequest)) {
                if (RestSqlAction.isExplainRequest(request)) {
                    throw new IllegalArgumentException("Invalid request. Cannot explain cursor");
                }
                LOG.info("[{}] Cursor request {}: {}", (Object)QueryContext.getRequestId(), (Object)request.uri(), (Object)sqlRequest.cursor());
                return channel -> this.handleCursorRequest(request, sqlRequest.cursor(), (Client)client, (RestChannel)channel);
            }
            LOG.info("[{}] Incoming request {}", (Object)QueryContext.getRequestId(), (Object)request.uri());
            Format format = SqlRequestParam.getFormat(request.params());
            SQLQueryRequest newSqlRequest = new SQLQueryRequest(sqlRequest.getJsonContent(), sqlRequest.getSql(), request.path(), request.params(), sqlRequest.cursor());
            return this.newSqlQueryHandler.prepareRequest(newSqlRequest, (restChannel, exception) -> {
                try {
                    if (newSqlRequest.isExplainRequest()) {
                        LOG.info("Request is falling back to old SQL engine due to: " + exception.getMessage());
                    }
                    LOG.info("[{}] Request {} is not supported and falling back to old SQL engine", (Object)QueryContext.getRequestId(), (Object)newSqlRequest);
                    LOG.info("Request Query: {}", (Object)QueryDataAnonymizer.anonymizeData(sqlRequest.getSql()));
                    QueryAction queryAction = RestSqlAction.explainRequest(client, sqlRequest, format);
                    this.executeSqlRequest(request, queryAction, (Client)client, (RestChannel)restChannel);
                }
                catch (Exception e) {
                    RestSqlAction.logAndPublishMetrics(e);
                    this.reportError((RestChannel)restChannel, e, RestSqlAction.isClientError(e) ? RestStatus.BAD_REQUEST : RestStatus.SERVICE_UNAVAILABLE);
                }
            }, (restChannel, exception) -> {
                RestSqlAction.logAndPublishMetrics(exception);
                this.reportError((RestChannel)restChannel, (Exception)exception, RestSqlAction.isClientError(exception) ? RestStatus.BAD_REQUEST : RestStatus.SERVICE_UNAVAILABLE);
            });
        }
        catch (Exception e) {
            RestSqlAction.logAndPublishMetrics(e);
            return channel -> this.reportError((RestChannel)channel, e, RestSqlAction.isClientError(e) ? RestStatus.BAD_REQUEST : RestStatus.SERVICE_UNAVAILABLE);
        }
    }

    private static boolean isLegacyCursor(SqlRequest sqlRequest) {
        String cursor = sqlRequest.cursor();
        return cursor != null && CursorType.getById(cursor.substring(0, 1)) != CursorType.NULL;
    }

    protected Set<String> responseParams() {
        HashSet<String> responseParams = new HashSet<String>(super.responseParams());
        responseParams.addAll(Arrays.asList("sql", "flat", "separator", "_score", "_type", "_id", "newLine", "format", "sanitize"));
        return responseParams;
    }

    private void handleCursorRequest(RestRequest request, String cursor, Client client, RestChannel channel) throws Exception {
        CursorAsyncRestExecutor cursorRestExecutor = CursorActionRequestRestExecutorFactory.createExecutor(request, cursor, SqlRequestParam.getFormat(request.params()));
        cursorRestExecutor.execute(client, request.params(), channel);
    }

    private static void logAndPublishMetrics(Exception e) {
        if (RestSqlAction.isClientError(e)) {
            LOG.error(QueryContext.getRequestId() + " Client side error during query execution", (Throwable)e);
            Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_CUS).increment();
        } else {
            LOG.error(QueryContext.getRequestId() + " Server side error during query execution", (Throwable)e);
            Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
        }
    }

    private static QueryAction explainRequest(NodeClient client, SqlRequest sqlRequest, Format format) throws SQLFeatureNotSupportedException, SqlParseException, SQLFeatureDisabledException {
        ColumnTypeProvider typeProvider = RestSqlAction.performAnalysis(sqlRequest.getSql());
        QueryAction queryAction = new SearchDao((Client)client).explain(new QueryActionRequest(sqlRequest.getSql(), typeProvider, format));
        queryAction.setSqlRequest(sqlRequest);
        queryAction.setFormat(format);
        queryAction.setColumnTypeProvider(typeProvider);
        return queryAction;
    }

    private void executeSqlRequest(RestRequest request, QueryAction queryAction, Client client, RestChannel channel) throws Exception {
        Map params = request.params();
        if (RestSqlAction.isExplainRequest(request)) {
            String jsonExplanation = queryAction.explain().explain();
            String result = SqlRequestParam.isPrettyFormat(params) ? JsonPrettyFormatter.format(jsonExplanation) : jsonExplanation;
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "application/json; charset=UTF-8", result));
        } else {
            RestExecutor restExecutor = ActionRequestRestExecutorFactory.createExecutor(SqlRequestParam.getFormat(params), queryAction);
            HashMap<String, String> additionalParams = new HashMap<String, String>();
            for (String paramName : this.responseParams()) {
                if (!request.hasParam(paramName)) continue;
                additionalParams.put(paramName, request.param(paramName));
            }
            restExecutor.execute(client, additionalParams, queryAction, channel);
        }
    }

    private static boolean isExplainRequest(RestRequest request) {
        return request.path().endsWith("/_explain");
    }

    private static boolean isClientError(Exception e) {
        return e instanceof NullPointerException || e instanceof SqlParseException || e instanceof ParserException || e instanceof SQLFeatureNotSupportedException || e instanceof SQLFeatureDisabledException || e instanceof IllegalArgumentException || e instanceof IndexNotFoundException || e instanceof VerificationException || e instanceof SqlAnalysisException || e instanceof SyntaxCheckException || e instanceof SemanticCheckException || e instanceof ExpressionEvaluationException;
    }

    private void sendResponse(RestChannel channel, String message, RestStatus status) {
        channel.sendResponse((RestResponse)new BytesRestResponse(status, message));
    }

    private void reportError(RestChannel channel, Exception e, RestStatus status) {
        this.sendResponse(channel, ErrorMessageFactory.createErrorMessage(e, status.getStatus()).toString(), status);
    }

    private boolean isSQLFeatureEnabled() {
        boolean isSqlEnabled = (Boolean)LocalClusterState.state().getSettingValue(Settings.Key.SQL_ENABLED);
        return this.allowExplicitIndex && isSqlEnabled;
    }

    private static ColumnTypeProvider performAnalysis(String sql) {
        SqlAnalysisConfig config = new SqlAnalysisConfig(false, false, 200);
        OpenSearchLegacySqlAnalyzer analyzer = new OpenSearchLegacySqlAnalyzer(config);
        LocalClusterState clusterState = LocalClusterState.state();
        Optional<Type> outputColumnType = analyzer.analyze(sql, clusterState);
        if (outputColumnType.isPresent()) {
            return new ColumnTypeProvider(outputColumnType.get());
        }
        return new ColumnTypeProvider();
    }
}

