/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.response;

import com.google.common.annotations.VisibleForTesting;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionFuture;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

public class SparkResponse {
    private final Client client;
    private String value;
    private final String field;
    private static final Logger LOG = LogManager.getLogger();

    public SparkResponse(Client client, String value, String field) {
        this.client = client;
        this.value = value;
        this.field = field;
    }

    public JSONObject getResultFromOpensearchIndex() {
        return this.searchInSparkIndex((QueryBuilder)QueryBuilders.termQuery((String)this.field, (String)this.value));
    }

    private JSONObject searchInSparkIndex(QueryBuilder query) {
        ActionFuture searchResponseActionFuture;
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(new String[]{".query_execution_result"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(query);
        searchRequest.source(searchSourceBuilder);
        try {
            searchResponseActionFuture = this.client.search(searchRequest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SearchResponse searchResponse = (SearchResponse)searchResponseActionFuture.actionGet();
        if (searchResponse.status().getStatus() != 200) {
            throw new RuntimeException("Fetching result from .query_execution_result index failed with status : " + searchResponse.status());
        }
        JSONObject data = new JSONObject();
        for (SearchHit searchHit : searchResponse.getHits().getHits()) {
            data.put("data", searchHit.getSourceAsMap());
            this.deleteInSparkIndex(searchHit.getId());
        }
        return data;
    }

    @VisibleForTesting
    void deleteInSparkIndex(String id) {
        ActionFuture deleteResponseActionFuture;
        DeleteRequest deleteRequest = new DeleteRequest(".query_execution_result");
        deleteRequest.id(id);
        try {
            deleteResponseActionFuture = this.client.delete(deleteRequest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        DeleteResponse deleteResponse = (DeleteResponse)deleteResponseActionFuture.actionGet();
        if (!deleteResponse.getResult().equals((Object)DocWriteResponse.Result.DELETED)) {
            if (deleteResponse.getResult().equals((Object)DocWriteResponse.Result.NOT_FOUND)) {
                throw new ResourceNotFoundException("Spark result with id " + id + " doesn't exist", new Object[0]);
            }
            throw new RuntimeException("Deleting spark result information failed with : " + deleteResponse.getResult().getLowercase());
        }
        LOG.debug("Spark result successfully deleted ", (Object)id);
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getField() {
        return this.field;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SparkResponse)) {
            return false;
        }
        SparkResponse other = (SparkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Client this$client = this.getClient();
        Client other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        return !(this$field == null ? other$field != null : !this$field.equals(other$field));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SparkResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Client $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SparkResponse(client=" + this.getClient() + ", value=" + this.getValue() + ", field=" + this.getField() + ")";
    }
}

