/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.context.active;

import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.SearchProgressListener;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchTask;
import org.opensearch.action.search.ShardSearchFailure;
import org.opensearch.common.Nullable;
import org.opensearch.common.SetOnce;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.authuser.User;
import org.opensearch.search.asynchronous.context.AsynchronousSearchContext;
import org.opensearch.search.asynchronous.context.AsynchronousSearchContextId;
import org.opensearch.search.asynchronous.context.permits.AsynchronousSearchContextPermits;
import org.opensearch.search.asynchronous.context.permits.NoopAsynchronousSearchContextPermits;
import org.opensearch.search.asynchronous.context.state.AsynchronousSearchState;
import org.opensearch.search.asynchronous.id.AsynchronousSearchId;
import org.opensearch.search.asynchronous.id.AsynchronousSearchIdConverter;
import org.opensearch.search.asynchronous.listener.AsynchronousSearchProgressListener;
import org.opensearch.threadpool.ThreadPool;

public class AsynchronousSearchActiveContext
extends AsynchronousSearchContext
implements Closeable {
    private final SetOnce<SearchTask> searchTask;
    private volatile long expirationTimeMillis;
    private long startTimeMillis;
    private final Boolean keepOnCompletion;
    private final TimeValue keepAlive;
    private final String nodeId;
    private final SetOnce<String> asynchronousSearchId;
    private final AtomicBoolean completed;
    private final SetOnce<Exception> error;
    private final SetOnce<SearchResponse> searchResponse;
    private final AtomicBoolean closed;
    private final Supplier<Boolean> persistSearchFailureSupplier;
    private final AsynchronousSearchContextPermits asynchronousSearchContextPermits;
    private final Supplier<SearchResponse> partialResponseSupplier;
    @Nullable
    private final User user;

    public AsynchronousSearchActiveContext(AsynchronousSearchContextId asynchronousSearchContextId, String nodeId, TimeValue keepAlive, boolean keepOnCompletion, ThreadPool threadPool, LongSupplier currentTimeSupplier, AsynchronousSearchProgressListener asynchronousSearchProgressListener, @Nullable User user, Supplier<Boolean> persistSearchFailureSupplier) {
        super(asynchronousSearchContextId, currentTimeSupplier);
        this.keepOnCompletion = keepOnCompletion;
        this.error = new SetOnce();
        this.searchResponse = new SetOnce();
        this.keepAlive = keepAlive;
        this.nodeId = nodeId;
        this.asynchronousSearchProgressListener = asynchronousSearchProgressListener;
        this.partialResponseSupplier = () -> asynchronousSearchProgressListener.partialResponse();
        this.searchTask = new SetOnce();
        this.asynchronousSearchId = new SetOnce();
        this.completed = new AtomicBoolean(false);
        this.closed = new AtomicBoolean(false);
        this.asynchronousSearchContextPermits = keepOnCompletion ? new AsynchronousSearchContextPermits(asynchronousSearchContextId, threadPool) : new NoopAsynchronousSearchContextPermits(asynchronousSearchContextId);
        this.user = user;
        this.persistSearchFailureSupplier = persistSearchFailureSupplier;
    }

    public void setTask(SearchTask searchTask) {
        assert (this.isAlive());
        assert (this.currentStage == AsynchronousSearchState.INIT);
        Objects.requireNonNull(searchTask);
        searchTask.setProgressListener((SearchProgressListener)this.asynchronousSearchProgressListener);
        this.searchTask.set((Object)searchTask);
        this.startTimeMillis = searchTask.getStartTime();
        this.expirationTimeMillis = this.startTimeMillis + this.keepAlive.getMillis();
        this.asynchronousSearchId.set((Object)AsynchronousSearchIdConverter.buildAsyncId(new AsynchronousSearchId(this.nodeId, searchTask.getId(), this.getContextId())));
    }

    public void processSearchFailure(Exception e) {
        assert (this.isAlive());
        try {
            if (e.getCause() != null) {
                e.getCause().setStackTrace(new StackTraceElement[0]);
            }
            this.error.set((Object)e);
        }
        finally {
            boolean result = this.completed.compareAndSet(false, true);
            assert (result) : "Process search failure already complete";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSearchResponse(SearchResponse response) {
        assert (this.isAlive());
        try {
            ShardSearchFailure[] shardSearchFailures;
            for (ShardSearchFailure shardSearchFailure : shardSearchFailures = response.getShardFailures()) {
                if (shardSearchFailure.getCause() == null) continue;
                shardSearchFailure.getCause().setStackTrace(new StackTraceElement[0]);
            }
            this.searchResponse.set((Object)response);
        }
        finally {
            boolean result = this.completed.compareAndSet(false, true);
            assert (result) : "Process search response already complete";
        }
    }

    @Override
    public SearchResponse getSearchResponse() {
        return this.completed.get() ? (SearchResponse)this.searchResponse.get() : this.partialResponseSupplier.get();
    }

    @Override
    public String getAsynchronousSearchId() {
        return (String)this.asynchronousSearchId.get();
    }

    public boolean shouldPersist() {
        return this.keepOnCompletion != false && !this.isExpired() && this.isAlive() && (this.error.get() == null || this.persistSearchFailureSupplier.get() != false);
    }

    public boolean keepOnCompletion() {
        return this.keepOnCompletion;
    }

    public void setExpirationTimeMillis(long expirationTimeMillis) {
        assert (this.isAlive());
        this.expirationTimeMillis = expirationTimeMillis;
    }

    public SearchTask getTask() {
        return (SearchTask)this.searchTask.get();
    }

    @Override
    public Exception getSearchError() {
        return (Exception)this.error.get();
    }

    @Override
    public long getExpirationTimeMillis() {
        return this.expirationTimeMillis;
    }

    @Override
    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    public void acquireContextPermitIfRequired(ActionListener<Releasable> onPermitAcquired, TimeValue timeout, String reason) {
        this.asynchronousSearchContextPermits.asyncAcquirePermit(onPermitAcquired, timeout, reason);
    }

    public void acquireAllContextPermits(ActionListener<Releasable> onPermitAcquired, TimeValue timeout, String reason) {
        this.asynchronousSearchContextPermits.asyncAcquireAllPermits(onPermitAcquired, timeout, reason);
    }

    public boolean isAlive() {
        if (this.closed.get()) {
            assert (this.getAsynchronousSearchState() == AsynchronousSearchState.CLOSED) : "State must be closed for asynchronous search id " + this.getAsynchronousSearchId();
            return false;
        }
        return true;
    }

    public boolean isCompleted() {
        return this.completed.get();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.asynchronousSearchContextPermits.close();
        }
    }
}

