/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves.rewrite;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.catalina.util.URLEncoder;
import org.apache.catalina.valves.rewrite.RewriteMap;
import org.apache.tomcat.util.buf.UDecoder;

public class InternalRewriteMap {
    public static RewriteMap toMap(String string) {
        if ("toupper".equals(string)) {
            return new UpperCase();
        }
        if ("tolower".equals(string)) {
            return new LowerCase();
        }
        if ("escape".equals(string)) {
            return new Escape();
        }
        if ("unescape".equals(string)) {
            return new Unescape();
        }
        return null;
    }

    public static class Unescape
    implements RewriteMap {
        private Charset charset = StandardCharsets.UTF_8;

        @Override
        public String setParameters(String string) {
            this.charset = Charset.forName(string);
            return null;
        }

        @Override
        public String lookup(String string) {
            if (string != null) {
                return UDecoder.URLDecode((String)string, (Charset)this.charset);
            }
            return null;
        }
    }

    public static class Escape
    implements RewriteMap {
        private Charset charset = StandardCharsets.UTF_8;

        @Override
        public String setParameters(String string) {
            this.charset = Charset.forName(string);
            return null;
        }

        @Override
        public String lookup(String string) {
            if (string != null) {
                return URLEncoder.DEFAULT.encode(string, this.charset);
            }
            return null;
        }
    }

    public static class UpperCase
    implements RewriteMap {
        private Locale locale = Locale.getDefault();

        @Override
        public String setParameters(String string) {
            this.locale = Locale.forLanguageTag(string);
            return null;
        }

        @Override
        public String lookup(String string) {
            if (string != null) {
                return string.toUpperCase(this.locale);
            }
            return null;
        }
    }

    public static class LowerCase
    implements RewriteMap {
        private Locale locale = Locale.getDefault();

        @Override
        public String setParameters(String string) {
            this.locale = Locale.forLanguageTag(string);
            return null;
        }

        @Override
        public String lookup(String string) {
            if (string != null) {
                return string.toLowerCase(this.locale);
            }
            return null;
        }
    }
}

