"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.analyzeShebang = exports.getShellDialect = exports.getShebang = void 0;
const SHEBANG_REGEXP = /^#!(.*)/;
const SHELL_REGEXP = /bin[/](?:env )?(\w+)/;
// Non exhaustive list of bash dialects that we potentially could support and try to analyze.
const BASH_DIALECTS = ['sh', 'bash', 'dash', 'ksh', 'zsh', 'csh', 'ash'];
function getShebang(fileContent) {
    const match = SHEBANG_REGEXP.exec(fileContent);
    if (!match || !match[1]) {
        return null;
    }
    return match[1].trim();
}
exports.getShebang = getShebang;
function getShellDialect(shebang) {
    const match = SHELL_REGEXP.exec(shebang);
    if (match && match[1]) {
        const bashDialect = match[1].trim();
        if (BASH_DIALECTS.includes(bashDialect)) {
            return bashDialect;
        }
    }
    return null;
}
exports.getShellDialect = getShellDialect;
function analyzeShebang(fileContent) {
    const shebang = getShebang(fileContent);
    return {
        shebang,
        shellDialect: shebang ? getShellDialect(shebang) : null,
    };
}
exports.analyzeShebang = analyzeShebang;
//# sourceMappingURL=shebang.js.map