/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class MockFilterChain
implements FilterChain {
    @Nullable
    private ServletRequest request;
    @Nullable
    private ServletResponse response;
    private final List<Filter> filters;
    @Nullable
    private Iterator<Filter> iterator;

    public MockFilterChain() {
        this.filters = Collections.emptyList();
    }

    public MockFilterChain(Servlet servlet) {
        this.filters = MockFilterChain.initFilterList(servlet, new Filter[0]);
    }

    public MockFilterChain(Servlet servlet, Filter ... filters) {
        Assert.notNull((Object)filters, (String)"filters cannot be null");
        Assert.noNullElements((Object[])filters, (String)"filters cannot contain null values");
        this.filters = MockFilterChain.initFilterList(servlet, filters);
    }

    private static List<Filter> initFilterList(Servlet servlet, Filter ... filters) {
        Filter[] allFilters = (Filter[])ObjectUtils.addObjectToArray((Object[])filters, (Object)new ServletFilterProxy(servlet));
        return Arrays.asList(allFilters);
    }

    @Nullable
    public ServletRequest getRequest() {
        return this.request;
    }

    @Nullable
    public ServletResponse getResponse() {
        return this.response;
    }

    public void doFilter(ServletRequest request2, ServletResponse response) throws IOException, ServletException {
        Assert.notNull((Object)request2, (String)"Request must not be null");
        Assert.notNull((Object)response, (String)"Response must not be null");
        Assert.state((this.request == null ? 1 : 0) != 0, (String)"This FilterChain has already been called!");
        if (this.iterator == null) {
            this.iterator = this.filters.iterator();
        }
        if (this.iterator.hasNext()) {
            Filter nextFilter = this.iterator.next();
            nextFilter.doFilter(request2, response, (FilterChain)this);
        }
        this.request = request2;
        this.response = response;
    }

    public void reset() {
        this.request = null;
        this.response = null;
        this.iterator = null;
    }

    private static final class ServletFilterProxy
    implements Filter {
        private final Servlet delegateServlet;

        private ServletFilterProxy(Servlet servlet) {
            Assert.notNull((Object)servlet, (String)"servlet cannot be null");
            this.delegateServlet = servlet;
        }

        public void doFilter(ServletRequest request2, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            this.delegateServlet.service(request2, response);
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void destroy() {
        }

        public String toString() {
            return this.delegateServlet.toString();
        }
    }
}

