/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Set;
import org.opensearch.ad.annotation.Generated;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.model.TimeConfiguration;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class IntervalTimeConfiguration
extends TimeConfiguration {
    private long interval;
    private ChronoUnit unit;
    private static final Set<ChronoUnit> SUPPORTED_UNITS = ImmutableSet.of((Object)ChronoUnit.MINUTES, (Object)ChronoUnit.SECONDS);

    public IntervalTimeConfiguration(long interval, ChronoUnit unit) {
        if (interval < 0L) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Interval %s %s", interval, CommonErrorMessages.NEGATIVE_TIME_CONFIGURATION));
        }
        if (!SUPPORTED_UNITS.contains(unit)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, CommonErrorMessages.INVALID_TIME_CONFIGURATION_UNITS, unit));
        }
        this.interval = interval;
        this.unit = unit;
    }

    public IntervalTimeConfiguration(StreamInput input) throws IOException {
        this.interval = input.readLong();
        this.unit = (ChronoUnit)input.readEnum(ChronoUnit.class);
    }

    public static IntervalTimeConfiguration readFrom(StreamInput input) throws IOException {
        return new IntervalTimeConfiguration(input);
    }

    public static long getIntervalInMinute(IntervalTimeConfiguration interval) {
        if (interval.getUnit() == ChronoUnit.SECONDS) {
            return interval.getInterval() / 60L;
        }
        return interval.getInterval();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.interval);
        out.writeEnum((Enum)this.unit);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().startObject("period").field("interval", this.interval).field("unit", (Object)this.unit).endObject().endObject();
        return builder;
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalTimeConfiguration that = (IntervalTimeConfiguration)o;
        return this.getInterval() == that.getInterval() && this.getUnit() == that.getUnit();
    }

    @Generated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.interval, this.unit});
    }

    public long getInterval() {
        return this.interval;
    }

    public ChronoUnit getUnit() {
        return this.unit;
    }

    public Duration toDuration() {
        return Duration.of(this.interval, this.unit);
    }
}

