/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.action.ActionResponse;
import org.opensearch.ad.model.ModelProfile;
import org.opensearch.ad.model.ModelProfileOnNode;
import org.opensearch.ad.util.Bwc;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class EntityProfileResponse
extends ActionResponse
implements ToXContentObject {
    public static final String ACTIVE = "active";
    public static final String LAST_ACTIVE_TS = "last_active_timestamp";
    public static final String TOTAL_UPDATES = "total_updates";
    private final Boolean isActive;
    private final long lastActiveMs;
    private final long totalUpdates;
    private final ModelProfileOnNode modelProfile;

    public EntityProfileResponse(Boolean isActive, long lastActiveTimeMs, long totalUpdates, ModelProfileOnNode modelProfile) {
        this.isActive = isActive;
        this.lastActiveMs = lastActiveTimeMs;
        this.totalUpdates = totalUpdates;
        this.modelProfile = modelProfile;
    }

    public EntityProfileResponse(StreamInput in) throws IOException {
        super(in);
        this.isActive = in.readOptionalBoolean();
        this.lastActiveMs = in.readLong();
        this.totalUpdates = in.readLong();
        if (in.readBoolean()) {
            if (Bwc.supportMultiCategoryFields(in.getVersion())) {
                this.modelProfile = new ModelProfileOnNode(in);
            } else {
                ModelProfile profile = new ModelProfile(in);
                this.modelProfile = new ModelProfileOnNode("", profile);
            }
        } else {
            this.modelProfile = null;
        }
    }

    public Optional<Boolean> isActive() {
        return Optional.ofNullable(this.isActive);
    }

    public long getLastActiveMs() {
        return this.lastActiveMs;
    }

    public long getTotalUpdates() {
        return this.totalUpdates;
    }

    public ModelProfileOnNode getModelProfile() {
        return this.modelProfile;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalBoolean(this.isActive);
        out.writeLong(this.lastActiveMs);
        out.writeLong(this.totalUpdates);
        if (this.modelProfile != null) {
            out.writeBoolean(true);
            if (Bwc.supportMultiCategoryFields(out.getVersion())) {
                this.modelProfile.writeTo(out);
            } else {
                ModelProfile oldFormatModelProfile = this.modelProfile.getModelProfile();
                oldFormatModelProfile.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.isActive != null) {
            builder.field(ACTIVE, this.isActive);
        }
        if (this.lastActiveMs >= 0L) {
            builder.field(LAST_ACTIVE_TS, this.lastActiveMs);
        }
        if (this.totalUpdates >= 0L) {
            builder.field(TOTAL_UPDATES, this.totalUpdates);
        }
        if (this.modelProfile != null) {
            builder.field("model", (ToXContent)this.modelProfile);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append(ACTIVE, (Object)this.isActive);
        builder.append(LAST_ACTIVE_TS, this.lastActiveMs);
        builder.append(TOTAL_UPDATES, this.totalUpdates);
        builder.append("model", (Object)this.modelProfile);
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (obj instanceof EntityProfileResponse) {
            EntityProfileResponse other = (EntityProfileResponse)((Object)obj);
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            equalsBuilder.append((Object)this.isActive, (Object)other.isActive);
            equalsBuilder.append(this.lastActiveMs, other.lastActiveMs);
            equalsBuilder.append(this.totalUpdates, other.totalUpdates);
            equalsBuilder.append((Object)this.modelProfile, (Object)other.modelProfile);
            return equalsBuilder.isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.isActive).append(this.lastActiveMs).append(this.totalUpdates).append((Object)this.modelProfile).toHashCode();
    }

    public static class Builder {
        private Boolean isActive = null;
        private long lastActiveMs = -1L;
        private long totalUpdates = -1L;
        private ModelProfileOnNode modelProfile = null;

        public Builder setActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public Builder setLastActiveMs(long lastActiveMs) {
            this.lastActiveMs = lastActiveMs;
            return this;
        }

        public Builder setTotalUpdates(long totalUpdates) {
            this.totalUpdates = totalUpdates;
            return this;
        }

        public Builder setModelProfile(ModelProfileOnNode modelProfile) {
            this.modelProfile = modelProfile;
            return this;
        }

        public EntityProfileResponse build() {
            return new EntityProfileResponse(this.isActive, this.lastActiveMs, this.totalUpdates, this.modelProfile);
        }
    }
}

