/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.time.Clock;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.ad.common.exception.ADValidationException;
import org.opensearch.ad.feature.SearchFeatureDao;
import org.opensearch.ad.indices.AnomalyDetectionIndices;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.DetectorValidationIssue;
import org.opensearch.ad.model.DetectorValidationIssueType;
import org.opensearch.ad.model.IntervalTimeConfiguration;
import org.opensearch.ad.model.ValidationAspect;
import org.opensearch.ad.rest.handler.AnomalyDetectorFunction;
import org.opensearch.ad.rest.handler.ValidateAnomalyDetectorActionHandler;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.transport.ValidateAnomalyDetectorAction;
import org.opensearch.ad.transport.ValidateAnomalyDetectorRequest;
import org.opensearch.ad.transport.ValidateAnomalyDetectorResponse;
import org.opensearch.ad.util.ParseUtils;
import org.opensearch.ad.util.SecurityClientUtil;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestRequest;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class ValidateAnomalyDetectorTransportAction
extends HandledTransportAction<ValidateAnomalyDetectorRequest, ValidateAnomalyDetectorResponse> {
    private static final Logger logger = LogManager.getLogger(ValidateAnomalyDetectorTransportAction.class);
    private final Client client;
    private final SecurityClientUtil clientUtil;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;
    private final AnomalyDetectionIndices anomalyDetectionIndices;
    private final SearchFeatureDao searchFeatureDao;
    private volatile Boolean filterByEnabled;
    private Clock clock;
    private Settings settings;

    @Inject
    public ValidateAnomalyDetectorTransportAction(Client client, SecurityClientUtil clientUtil, ClusterService clusterService, NamedXContentRegistry xContentRegistry, Settings settings, AnomalyDetectionIndices anomalyDetectionIndices, ActionFilters actionFilters, TransportService transportService, SearchFeatureDao searchFeatureDao) {
        super(ValidateAnomalyDetectorAction.NAME, transportService, actionFilters, ValidateAnomalyDetectorRequest::new);
        this.client = client;
        this.clientUtil = clientUtil;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.anomalyDetectionIndices = anomalyDetectionIndices;
        this.filterByEnabled = (Boolean)AnomalyDetectorSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
        this.searchFeatureDao = searchFeatureDao;
        this.clock = Clock.systemUTC();
        this.settings = settings;
    }

    protected void doExecute(Task task, ValidateAnomalyDetectorRequest request, ActionListener<ValidateAnomalyDetectorResponse> listener) {
        User user = ParseUtils.getUserContext(this.client);
        AnomalyDetector anomalyDetector = request.getDetector();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.resolveUserAndExecute(user, listener, () -> this.validateExecute(request, user, context, listener));
        }
        catch (Exception e) {
            logger.error((Object)e);
            listener.onFailure(e);
        }
    }

    private void resolveUserAndExecute(User requestedUser, ActionListener<ValidateAnomalyDetectorResponse> listener, AnomalyDetectorFunction function) {
        try {
            if (this.filterByEnabled.booleanValue() && !ParseUtils.checkFilterByBackendRoles(requestedUser, listener)) {
                return;
            }
            function.execute();
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void validateExecute(ValidateAnomalyDetectorRequest request, User user, ThreadContext.StoredContext storedContext, ActionListener<ValidateAnomalyDetectorResponse> listener) {
        storedContext.restore();
        AnomalyDetector detector = request.getDetector();
        ActionListener validateListener = ActionListener.wrap(response -> {
            logger.debug("Result of validation process " + response);
            listener.onResponse((Object)new ValidateAnomalyDetectorResponse((DetectorValidationIssue)null));
        }, exception -> {
            if (exception instanceof ADValidationException) {
                DetectorValidationIssue issue = this.parseADValidationException((ADValidationException)exception);
                listener.onResponse((Object)new ValidateAnomalyDetectorResponse(issue));
                return;
            }
            logger.error(exception);
            listener.onFailure(exception);
        });
        this.checkIndicesAndExecute(detector.getIndices(), () -> {
            ValidateAnomalyDetectorActionHandler handler = new ValidateAnomalyDetectorActionHandler(this.clusterService, this.client, this.clientUtil, (ActionListener<ValidateAnomalyDetectorResponse>)validateListener, this.anomalyDetectionIndices, detector, request.getRequestTimeout(), request.getMaxSingleEntityAnomalyDetectors(), request.getMaxMultiEntityAnomalyDetectors(), request.getMaxAnomalyFeatures(), RestRequest.Method.POST, this.xContentRegistry, user, this.searchFeatureDao, request.getValidationType(), this.clock, this.settings);
            try {
                handler.start();
            }
            catch (Exception exception) {
                String errorMessage = String.format(Locale.ROOT, "Unknown exception caught while validating detector %s", request.getDetector());
                logger.error(errorMessage, (Throwable)exception);
                listener.onFailure(exception);
            }
        }, listener);
    }

    protected DetectorValidationIssue parseADValidationException(ADValidationException exception) {
        String originalErrorMessage = exception.getMessage();
        String errorMessage = "";
        Map<String, String> subIssues = null;
        IntervalTimeConfiguration intervalSuggestion = exception.getIntervalSuggestion();
        switch (exception.getType()) {
            case FEATURE_ATTRIBUTES: {
                int firstLeftBracketIndex = originalErrorMessage.indexOf("[");
                int lastRightBracketIndex = originalErrorMessage.lastIndexOf("]");
                if (firstLeftBracketIndex != -1) {
                    errorMessage = originalErrorMessage.substring(firstLeftBracketIndex + 1, lastRightBracketIndex);
                    subIssues = this.getFeatureSubIssuesFromErrorMessage(errorMessage);
                    break;
                }
                errorMessage = originalErrorMessage;
                break;
            }
            case NAME: 
            case CATEGORY: 
            case DETECTION_INTERVAL: 
            case FILTER_QUERY: 
            case TIMEFIELD_FIELD: 
            case SHINGLE_SIZE_FIELD: 
            case WINDOW_DELAY: 
            case RESULT_INDEX: 
            case GENERAL_SETTINGS: 
            case AGGREGATION: 
            case TIMEOUT: 
            case INDICES: {
                errorMessage = originalErrorMessage;
            }
        }
        return new DetectorValidationIssue(exception.getAspect(), exception.getType(), errorMessage, subIssues, intervalSuggestion);
    }

    private Map<String, String> getFeatureSubIssuesFromErrorMessage(String errorMessage) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] subIssueMessagesSuffix = errorMessage.split(", ");
        for (int i = 0; i < subIssueMessagesSuffix.length; ++i) {
            result.put(subIssueMessagesSuffix[i].split(": ")[1], subIssueMessagesSuffix[i].split(": ")[0]);
        }
        return result;
    }

    private void checkIndicesAndExecute(List<String> indices, AnomalyDetectorFunction function, ActionListener<ValidateAnomalyDetectorResponse> listener) {
        SearchRequest searchRequest = new SearchRequest().indices(indices.toArray(new String[0])).source(new SearchSourceBuilder().size(1).query((QueryBuilder)QueryBuilders.matchAllQuery()));
        this.client.search(searchRequest, ActionListener.wrap(r -> function.execute(), e -> {
            if (e instanceof IndexNotFoundException) {
                DetectorValidationIssue issue = this.parseADValidationException(new ADValidationException("index does not exist", DetectorValidationIssueType.INDICES, ValidationAspect.DETECTOR));
                listener.onResponse((Object)new ValidateAnomalyDetectorResponse(issue));
                return;
            }
            logger.error(e);
            listener.onFailure(e);
        }));
    }
}

