/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication;

import java.util.Arrays;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ShardOperationFailedException;
import org.opensearch.index.shard.ShardId;
import org.opensearch.rest.RestStatus;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\u000bB#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\fB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\rB+\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\u000eB\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/replication/ReplicationException;", "Lorg/opensearch/OpenSearchStatusException;", "message", "", "status", "Lorg/opensearch/rest/RestStatus;", "cause", "", "args", "", "", "(Ljava/lang/String;Lorg/opensearch/rest/RestStatus;Ljava/lang/Throwable;[Ljava/lang/Object;)V", "(Ljava/lang/String;[Ljava/lang/Object;)V", "(Ljava/lang/String;Lorg/opensearch/rest/RestStatus;[Ljava/lang/Object;)V", "(Ljava/lang/Throwable;Lorg/opensearch/rest/RestStatus;[Ljava/lang/Object;)V", "shardFailures", "Lorg/opensearch/action/ShardOperationFailedException;", "(Ljava/lang/String;[Lorg/opensearch/action/ShardOperationFailedException;)V", "opensearch-cross-cluster-replication"})
public final class ReplicationException
extends OpenSearchStatusException {
    public ReplicationException(@NotNull String message, @NotNull RestStatus status, @NotNull Throwable cause, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super(message, status, cause, Arrays.copyOf(args, args.length));
    }

    public ReplicationException(@NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super(message, RestStatus.INTERNAL_SERVER_ERROR, Arrays.copyOf(args, args.length));
    }

    public ReplicationException(@NotNull String message, @NotNull RestStatus status, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super(message, status, Arrays.copyOf(args, args.length));
    }

    public ReplicationException(@NotNull Throwable cause, @NotNull RestStatus status, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super(cause.getMessage(), status, Arrays.copyOf(args, args.length));
    }

    public ReplicationException(@NotNull String message, @NotNull ShardOperationFailedException[] shardFailures) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)shardFailures, (String)"shardFailures");
        ShardOperationFailedException shardOperationFailedException = (ShardOperationFailedException)ArraysKt.firstOrNull((Object[])shardFailures);
        Object object = shardOperationFailedException == null ? null : shardOperationFailedException.status();
        if (object == null) {
            object = RestStatus.INTERNAL_SERVER_ERROR;
        }
        super(message, object, new Object[0]);
        ShardOperationFailedException shardOperationFailedException2 = (ShardOperationFailedException)ArraysKt.firstOrNull((Object[])shardFailures);
        if (shardOperationFailedException2 != null) {
            ShardOperationFailedException it = shardOperationFailedException2;
            boolean bl = false;
            this.setShard(new ShardId(it.index(), "_na_", it.shardId()));
            this.initCause(it.getCause());
            Iterable $this$forEach$iv = ArraysKt.drop((Object[])shardFailures, (int)1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ShardOperationFailedException f = (ShardOperationFailedException)element$iv;
                boolean bl2 = false;
                Throwable throwable = (Throwable)((Object)this);
                Throwable throwable2 = f.getCause();
                Intrinsics.checkNotNullExpressionValue((Object)throwable2, (String)"f.cause");
                ExceptionsKt.addSuppressed((Throwable)throwable, (Throwable)throwable2);
            }
        }
    }
}

