/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.ui;

import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTableModel;
import org.openide.util.Exceptions;

class HeapViewerTreeTable
extends ProfilerTreeTable {
    private volatile boolean initializing = true;
    private boolean sorting;

    HeapViewerTreeTable(ProfilerTreeTableModel model, List<? extends RowSorter.SortKey> sortKeys) {
        super(model, true, true, new int[]{0});
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setShadeUnfocusedSelection(true);
        this.setForgetPreviouslyExpanded(true);
        this.setAllowsThreeStateColumns(true);
        this.getRowSorter().setSortKeys(sortKeys);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            private HeapViewerNode currentSelected;
            private boolean currentAdjusting;
            private boolean adjustingNull;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (HeapViewerTreeTable.this.sorting) {
                    return;
                }
                HeapViewerNode node = HeapViewerTreeTable.this.getSelectedNode();
                boolean adjusting = e.getValueIsAdjusting();
                if (node == null) {
                    if (adjusting) {
                        this.adjustingNull = true;
                        return;
                    }
                    if (this.adjustingNull) {
                        this.adjustingNull = false;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (HeapViewerTreeTable.this.getSelectedNode() == null) {
                                    HeapViewerTreeTable.this.nodeSelected(null, false);
                                }
                            }
                        });
                        return;
                    }
                } else {
                    this.adjustingNull = false;
                }
                if (Objects.equals((Object)this.currentSelected, (Object)node) && this.currentAdjusting == adjusting) {
                    return;
                }
                this.currentSelected = node;
                this.currentAdjusting = adjusting;
                HeapViewerTreeTable.this.nodeSelected(node, adjusting);
            }
        });
        this.initializing = false;
    }

    protected final boolean isInitializing() {
        return this.initializing;
    }

    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
    }

    protected void forgetChildren(HeapViewerNode node) {
    }

    protected void nodeCollapsed(final TreeNode node) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HeapViewerTreeTable.this.forgetChildren((HeapViewerNode)((Object)node));
            }
        });
    }

    protected void willBeSorted(List<? extends RowSorter.SortKey> sortKeys) {
        this.sorting = true;
        final HeapViewerNode beforeSortingSelected = this.getSelectedNode();
        final ProfilerTreeTable.UIState uiState = this.getUIState();
        try {
            Enumeration expanded = this.getExpandedNodes();
            this.clearSelection();
            if (expanded != null) {
                while (expanded.hasMoreElements()) {
                    HeapViewerNode node = (HeapViewerNode)((Object)((TreePath)expanded.nextElement()).getLastPathComponent());
                    node.willBeSorted();
                }
            }
        }
        catch (Throwable t) {
            Exceptions.printStackTrace((Throwable)t);
        }
        this.resetPath(null);
        if (uiState != null) {
            this.restoreSelectedNodes(uiState);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HeapViewerTreeTable.this.restoreExpandedNodes(uiState);
                    HeapViewerTreeTable.this.sorting = false;
                    HeapViewerNode afterSortingSelected = HeapViewerTreeTable.this.getSelectedNode();
                    if (!Objects.equals((Object)beforeSortingSelected, (Object)afterSortingSelected)) {
                        HeapViewerTreeTable.this.nodeSelected(afterSortingSelected, false);
                    }
                }
            });
        } else {
            this.sorting = false;
            HeapViewerNode afterSortingSelected = this.getSelectedNode();
            if (!Objects.equals((Object)beforeSortingSelected, (Object)afterSortingSelected)) {
                this.nodeSelected(afterSortingSelected, false);
            }
        }
    }

    private HeapViewerNode getSelectedNode() {
        int row = this.getSelectedRow();
        return row == -1 ? null : (HeapViewerNode)((Object)this.getValueForRow(row));
    }
}

