"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsPlugin = NotificationsPlugin;

var _common = require("../../common");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function NotificationsPlugin(Client, config, components) {
  const clientAction = components.clientAction.factory;
  Client.prototype.notifications = components.clientAction.namespaceFactory();
  const notifications = Client.prototype.notifications.prototype;
  notifications.getConfigs = clientAction({
    url: {
      fmt: _common.NOTIFICATIONS_API.CONFIGS
    },
    method: 'GET'
  });
  notifications.getEventById = clientAction({
    url: {
      fmt: `${_common.NOTIFICATIONS_API.EVENTS}/<%=eventId%>`,
      req: {
        eventId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  notifications.sendTestMessage = clientAction({
    url: {
      fmt: `${_common.NOTIFICATIONS_API.TEST_MESSAGE}/<%=configId%>`,
      req: {
        configId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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