/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.snapshotmanagement.api.resthandler;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.client.node.NodeClient;
import org.opensearch.indexmanagement.common.model.rest.SearchParams;
import org.opensearch.indexmanagement.snapshotmanagement.SMUtilsKt;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.SMActions;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.get.GetSMPoliciesRequest;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.get.GetSMPolicyRequest;
import org.opensearch.indexmanagement.util.RestHandlerUtilsKt;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/api/resthandler/RestGetSMPolicyHandler;", "Lorg/opensearch/rest/BaseRestHandler;", "()V", "getAllPolicies", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/client/node/NodeClient;", "getName", "", "getSMPolicyByName", "policyName", "prepareRequest", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "opensearch-index-management"})
public final class RestGetSMPolicyHandler
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "snapshot_management_get_policy_rest_handler";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        Object[] objectArray = new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_sm/policies/{policyName}"), new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_sm/policies/")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String policyName = request.param("policyName", "");
        Intrinsics.checkNotNullExpressionValue((Object)policyName, (String)"policyName");
        return ((CharSequence)policyName).length() == 0 ? this.getAllPolicies(request, client) : this.getSMPolicyByName(client, policyName);
    }

    private final BaseRestHandler.RestChannelConsumer getSMPolicyByName(NodeClient client, String policyName) {
        return arg_0 -> RestGetSMPolicyHandler.getSMPolicyByName$lambda$0(client, policyName, arg_0);
    }

    private final BaseRestHandler.RestChannelConsumer getAllPolicies(RestRequest request, NodeClient client) {
        SearchParams searchParams = RestHandlerUtilsKt.getSearchParams(request, "sm_policy.name");
        return arg_0 -> RestGetSMPolicyHandler.getAllPolicies$lambda$1(client, searchParams, arg_0);
    }

    private static final void getSMPolicyByName$lambda$0(NodeClient $client, String $policyName, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$policyName, (String)"$policyName");
        $client.execute(SMActions.INSTANCE.getGET_SM_POLICY_ACTION_TYPE(), (ActionRequest)new GetSMPolicyRequest(SMUtilsKt.smPolicyNameToDocId($policyName)), (ActionListener)new RestToXContentListener(it));
    }

    private static final void getAllPolicies$lambda$1(NodeClient $client, SearchParams $searchParams, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$searchParams, (String)"$searchParams");
        $client.execute(SMActions.INSTANCE.getGET_SM_POLICIES_ACTION_TYPE(), (ActionRequest)new GetSMPoliciesRequest($searchParams), (ActionListener)new RestToXContentListener(it));
    }
}

