/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.common.collect.Tuple;
import software.amazon.awssdk.core.exception.SdkException;

public class HttpRangeUtils {
    private static final Pattern RANGE_PATTERN = Pattern.compile("^bytes=([0-9]+)-([0-9]+)$");

    public static Tuple<Long, Long> fromHttpRangeHeader(String headerValue) {
        Matcher matcher = RANGE_PATTERN.matcher(headerValue);
        if (!matcher.find()) {
            throw SdkException.create((String)("Regex match for Content-Range header {" + headerValue + "} failed"), (Throwable)new RuntimeException());
        }
        return new Tuple((Object)Long.parseLong(matcher.group(1)), (Object)Long.parseLong(matcher.group(2)));
    }

    public static String toHttpRangeHeader(long start, long end) {
        return "bytes=" + start + "-" + end;
    }
}

