// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import { NodeDefaultCryptographicMaterialsManager, KeyringNode, } from '@aws-crypto/material-management-node';
import { ParseHeaderStream } from './parse_header_stream';
import { VerifyStream } from './verify_stream';
import { getDecipherStream } from './decipher_stream';
import Duplexify from 'duplexify';
// @ts-ignore
import { pipeline, PassThrough } from 'readable-stream';
export function _decryptStream(decryptParameters, cmm, { maxBodySize } = {}) {
    /* If the cmm is a Keyring, wrap it with NodeDefaultCMM. */
    cmm =
        cmm instanceof KeyringNode
            ? new NodeDefaultCryptographicMaterialsManager(cmm)
            : cmm;
    const parseHeaderStream = new ParseHeaderStream(decryptParameters.signaturePolicy, decryptParameters.clientOptions, cmm);
    const verifyStream = new VerifyStream({ maxBodySize });
    const decipherStream = getDecipherStream();
    const stream = new Duplexify(parseHeaderStream, decipherStream);
    /* pipeline will _either_ stream.destroy or the callback.
     * decipherStream uses destroy to dispose the material.
     * So I tack a pass though stream onto the end.
     */
    pipeline(parseHeaderStream, verifyStream, decipherStream, new PassThrough(), (err) => {
        if (err)
            stream.emit('error', err);
    });
    // Forward header events
    parseHeaderStream.once('MessageHeader', (header) => stream.emit('MessageHeader', header));
    return stream;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVjcnlwdF9zdHJlYW0uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvZGVjcnlwdF9zdHJlYW0udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsb0VBQW9FO0FBQ3BFLHNDQUFzQztBQUV0QyxPQUFPLEVBQ0wsd0NBQXdDLEVBQ3hDLFdBQVcsR0FFWixNQUFNLHNDQUFzQyxDQUFBO0FBQzdDLE9BQU8sRUFBRSxpQkFBaUIsRUFBRSxNQUFNLHVCQUF1QixDQUFBO0FBQ3pELE9BQU8sRUFBRSxZQUFZLEVBQUUsTUFBTSxpQkFBaUIsQ0FBQTtBQUM5QyxPQUFPLEVBQUUsaUJBQWlCLEVBQUUsTUFBTSxtQkFBbUIsQ0FBQTtBQUVyRCxPQUFPLFNBQVMsTUFBTSxXQUFXLENBQUE7QUFHakMsYUFBYTtBQUNiLE9BQU8sRUFBRSxRQUFRLEVBQUUsV0FBVyxFQUFFLE1BQU0saUJBQWlCLENBQUE7QUFFdkQsTUFBTSxVQUFVLGNBQWMsQ0FDNUIsaUJBQW9DLEVBQ3BDLEdBQXVDLEVBQ3ZDLEVBQUUsV0FBVyxLQUEyQixFQUFFO0lBRTFDLDJEQUEyRDtJQUMzRCxHQUFHO1FBQ0QsR0FBRyxZQUFZLFdBQVc7WUFDeEIsQ0FBQyxDQUFDLElBQUksd0NBQXdDLENBQUMsR0FBRyxDQUFDO1lBQ25ELENBQUMsQ0FBQyxHQUFHLENBQUE7SUFFVCxNQUFNLGlCQUFpQixHQUFHLElBQUksaUJBQWlCLENBQzdDLGlCQUFpQixDQUFDLGVBQWUsRUFDakMsaUJBQWlCLENBQUMsYUFBYSxFQUMvQixHQUFHLENBQ0osQ0FBQTtJQUNELE1BQU0sWUFBWSxHQUFHLElBQUksWUFBWSxDQUFDLEVBQUUsV0FBVyxFQUFFLENBQUMsQ0FBQTtJQUN0RCxNQUFNLGNBQWMsR0FBRyxpQkFBaUIsRUFBRSxDQUFBO0lBQzFDLE1BQU0sTUFBTSxHQUFHLElBQUksU0FBUyxDQUFDLGlCQUFpQixFQUFFLGNBQWMsQ0FBQyxDQUFBO0lBRS9EOzs7T0FHRztJQUNILFFBQVEsQ0FDTixpQkFBaUIsRUFDakIsWUFBWSxFQUNaLGNBQWMsRUFDZCxJQUFJLFdBQVcsRUFBRSxFQUNqQixDQUFDLEdBQVUsRUFBRSxFQUFFO1FBQ2IsSUFBSSxHQUFHO1lBQUUsTUFBTSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLENBQUE7SUFDcEMsQ0FBQyxDQUNGLENBQUE7SUFFRCx3QkFBd0I7SUFDeEIsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGVBQWUsRUFBRSxDQUFDLE1BQU0sRUFBRSxFQUFFLENBQ2pELE1BQU0sQ0FBQyxJQUFJLENBQUMsZUFBZSxFQUFFLE1BQU0sQ0FBQyxDQUNyQyxDQUFBO0lBRUQsT0FBTyxNQUFNLENBQUE7QUFDZixDQUFDIn0=