/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input.remote;

import java.io.IOException;
import java.util.Map;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.utils.StringUtils;

@org.opensearch.ml.common.annotation.MLInput(functionNames={FunctionName.REMOTE})
public class RemoteInferenceMLInput
extends MLInput {
    public static final String PARAMETERS_FIELD = "parameters";

    public RemoteInferenceMLInput(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }

    public RemoteInferenceMLInput(XContentParser parser, FunctionName functionName) throws IOException {
        this.algorithm = functionName;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block6: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "parameters": {
                    Map<String, String> parameters = StringUtils.getParameterMap(parser.map());
                    this.inputDataset = new RemoteInferenceInputDataSet(parameters);
                    continue block6;
                }
            }
            parser.skipChildren();
        }
    }
}

