# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2013 Kristian Høgsberg
# Copyright © 2013      Rafael Antognolli
# Copyright © 2013      Jasper St. Pierre
# Copyright © 2010-2013 Intel Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)
from .zxdg_popup_v6 import ZxdgPopupV6
from .zxdg_positioner_v6 import ZxdgPositionerV6
from .zxdg_toplevel_v6 import ZxdgToplevelV6


class ZxdgSurfaceV6(Interface):
    """Desktop user interface surface base interface

    An interface that may be implemented by a
    :class:`~pywayland.protocol.wayland.WlSurface`, for implementations that
    provide a desktop-style user interface.

    It provides a base set of functionality required to construct user
    interface elements requiring management by the compositor, such as toplevel
    windows, menus, etc. The types of functionality are split into
    :class:`~pywayland.protocol.xdg_shell.XdgSurface` roles.

    Creating an :class:`~pywayland.protocol.xdg_shell.XdgSurface` does not set
    the role for a :class:`~pywayland.protocol.wayland.WlSurface`. In order to
    map an :class:`~pywayland.protocol.xdg_shell.XdgSurface`, the client must
    create a role-specific object using, e.g., get_toplevel, get_popup. The
    :class:`~pywayland.protocol.wayland.WlSurface` for any given
    :class:`~pywayland.protocol.xdg_shell.XdgSurface` can have at most one
    role, and may not be assigned any role not based on
    :class:`~pywayland.protocol.xdg_shell.XdgSurface`.

    A role must be assigned before any other requests are made to the
    :class:`~pywayland.protocol.xdg_shell.XdgSurface` object.

    The client must call :func:`WlSurface.commit()
    <pywayland.protocol.wayland.WlSurface.commit>` on the corresponding
    :class:`~pywayland.protocol.wayland.WlSurface` for the
    :class:`~pywayland.protocol.xdg_shell.XdgSurface` state to take effect.

    Creating an :class:`~pywayland.protocol.xdg_shell.XdgSurface` from a
    :class:`~pywayland.protocol.wayland.WlSurface` which has a buffer attached
    or committed is a client error, and any attempts by a client to attach or
    manipulate a buffer prior to the first :func:`XdgSurface.configure()
    <pywayland.protocol.xdg_shell.XdgSurface.configure>` call must also be
    treated as errors.

    For a surface to be mapped by the compositor, the following conditions must
    be met: (1) the client has assigned an
    :class:`~pywayland.protocol.xdg_shell.XdgSurface` based role to the
    surface, (2) the client has set and committed the
    :class:`~pywayland.protocol.xdg_shell.XdgSurface` state and the role
    dependent state to the surface and (3) the client has committed a buffer to
    the surface.
    """

    name = "zxdg_surface_v6"
    version = 1

    class error(enum.IntEnum):
        not_constructed = 1
        already_constructed = 2
        unconfigured_buffer = 3


class ZxdgSurfaceV6Proxy(Proxy[ZxdgSurfaceV6]):
    interface = ZxdgSurfaceV6

    @ZxdgSurfaceV6.request()
    def destroy(self) -> None:
        """Destroy the :class:`~pywayland.protocol.xdg_shell.XdgSurface`

        Destroy the :class:`~pywayland.protocol.xdg_shell.XdgSurface` object.
        An :class:`~pywayland.protocol.xdg_shell.XdgSurface` must only be
        destroyed after its role object has been destroyed.
        """
        self._marshal(0)
        self._destroy()

    @ZxdgSurfaceV6.request(
        Argument(ArgumentType.NewId, interface=ZxdgToplevelV6),
    )
    def get_toplevel(self) -> Proxy[ZxdgToplevelV6]:
        """Assign the :class:`~pywayland.protocol.xdg_shell.XdgToplevel` surface role

        This creates an :class:`~pywayland.protocol.xdg_shell.XdgToplevel`
        object for the given :class:`~pywayland.protocol.xdg_shell.XdgSurface`
        and gives the associated :class:`~pywayland.protocol.wayland.WlSurface`
        the :class:`~pywayland.protocol.xdg_shell.XdgToplevel` role.

        See the documentation of
        :class:`~pywayland.protocol.xdg_shell.XdgToplevel` for more details
        about what an :class:`~pywayland.protocol.xdg_shell.XdgToplevel` is and
        how it is used.

        :returns:
            :class:`~pywayland.protocol.xdg_shell_unstable_v6.ZxdgToplevelV6`
        """
        id = self._marshal_constructor(1, ZxdgToplevelV6)
        return id

    @ZxdgSurfaceV6.request(
        Argument(ArgumentType.NewId, interface=ZxdgPopupV6),
        Argument(ArgumentType.Object, interface=ZxdgSurfaceV6),
        Argument(ArgumentType.Object, interface=ZxdgPositionerV6),
    )
    def get_popup(self, parent: ZxdgSurfaceV6, positioner: ZxdgPositionerV6) -> Proxy[ZxdgPopupV6]:
        """Assign the :class:`~pywayland.protocol.xdg_shell.XdgPopup` surface role

        This creates an :class:`~pywayland.protocol.xdg_shell.XdgPopup` object
        for the given :class:`~pywayland.protocol.xdg_shell.XdgSurface` and
        gives the associated :class:`~pywayland.protocol.wayland.WlSurface` the
        :class:`~pywayland.protocol.xdg_shell.XdgPopup` role.

        See the documentation of
        :class:`~pywayland.protocol.xdg_shell.XdgPopup` for more details about
        what an :class:`~pywayland.protocol.xdg_shell.XdgPopup` is and how it
        is used.

        :param parent:
        :type parent:
            :class:`ZxdgSurfaceV6`
        :param positioner:
        :type positioner:
            :class:`~pywayland.protocol.xdg_shell_unstable_v6.ZxdgPositionerV6`
        :returns:
            :class:`~pywayland.protocol.xdg_shell_unstable_v6.ZxdgPopupV6`
        """
        id = self._marshal_constructor(2, ZxdgPopupV6, parent, positioner)
        return id

    @ZxdgSurfaceV6.request(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def set_window_geometry(self, x: int, y: int, width: int, height: int) -> None:
        """Set the new window geometry

        The window geometry of a surface is its "visible bounds" from the
        user's perspective. Client-side decorations often have invisible
        portions like drop-shadows which should be ignored for the purposes of
        aligning, placing and constraining windows.

        The window geometry is double buffered, and will be applied at the time
        :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` of the corresponding
        :class:`~pywayland.protocol.wayland.WlSurface` is called.

        Once the window geometry of the surface is set, it is not possible to
        unset it, and it will remain the same until set_window_geometry is
        called again, even if a new subsurface or buffer is attached.

        If never set, the value is the full bounds of the surface, including
        any subsurfaces. This updates dynamically on every commit. This unset
        is meant for extremely simple clients.

        The arguments are given in the surface-local coordinate space of the
        :class:`~pywayland.protocol.wayland.WlSurface` associated with this
        :class:`~pywayland.protocol.xdg_shell.XdgSurface`.

        The width and height must be greater than zero. Setting an invalid size
        will raise an error. When applied, the effective window geometry will
        be the set window geometry clamped to the bounding rectangle of the
        combined geometry of the surface of the
        :class:`~pywayland.protocol.xdg_shell.XdgSurface` and the associated
        subsurfaces.

        :param x:
        :type x:
            `ArgumentType.Int`
        :param y:
        :type y:
            `ArgumentType.Int`
        :param width:
        :type width:
            `ArgumentType.Int`
        :param height:
        :type height:
            `ArgumentType.Int`
        """
        self._marshal(3, x, y, width, height)

    @ZxdgSurfaceV6.request(
        Argument(ArgumentType.Uint),
    )
    def ack_configure(self, serial: int) -> None:
        """Ack a configure event

        When a configure event is received, if a client commits the surface in
        response to the configure event, then the client must make an
        ack_configure request sometime before the commit request, passing along
        the serial of the configure event.

        For instance, for toplevel surfaces the compositor might use this
        information to move a surface to the top left only when the client has
        drawn itself for the maximized or fullscreen state.

        If the client receives multiple configure events before it can respond
        to one, it only has to ack the last configure event.

        A client is not required to commit immediately after sending an
        ack_configure request - it may even ack_configure several times before
        its next surface commit.

        A client may send multiple ack_configure requests before committing,
        but only the last request sent before a commit indicates which
        configure event the client really is responding to.

        :param serial:
            the serial from the configure event
        :type serial:
            `ArgumentType.Uint`
        """
        self._marshal(4, serial)


class ZxdgSurfaceV6Resource(Resource):
    interface = ZxdgSurfaceV6

    @ZxdgSurfaceV6.event(
        Argument(ArgumentType.Uint),
    )
    def configure(self, serial: int) -> None:
        """Suggest a surface change

        The configure event marks the end of a configure sequence. A configure
        sequence is a set of one or more events configuring the state of the
        :class:`~pywayland.protocol.xdg_shell.XdgSurface`, including the final
        :func:`XdgSurface.configure()
        <pywayland.protocol.xdg_shell.XdgSurface.configure>` event.

        Where applicable, :class:`~pywayland.protocol.xdg_shell.XdgSurface`
        surface roles will during a configure sequence extend this event as a
        latched state sent as events before the :func:`XdgSurface.configure()
        <pywayland.protocol.xdg_shell.XdgSurface.configure>` event. Such events
        should be considered to make up a set of atomically applied
        configuration states, where the :func:`XdgSurface.configure()
        <pywayland.protocol.xdg_shell.XdgSurface.configure>` commits the
        accumulated state.

        Clients should arrange their surface for the new states, and then send
        an ack_configure request with the serial sent in this configure event
        at some point before committing the new surface.

        If the client receives multiple configure events before it can respond
        to one, it is free to discard all but the last event it received.

        :param serial:
            serial of the configure event
        :type serial:
            `ArgumentType.Uint`
        """
        self._post_event(0, serial)


class ZxdgSurfaceV6Global(Global):
    interface = ZxdgSurfaceV6


ZxdgSurfaceV6._gen_c()
ZxdgSurfaceV6.proxy_class = ZxdgSurfaceV6Proxy
ZxdgSurfaceV6.resource_class = ZxdgSurfaceV6Resource
ZxdgSurfaceV6.global_class = ZxdgSurfaceV6Global
