# `MD052` - Reference links and images should use a label that is defined

Tags: `images`, `links`

Aliases: `reference-links-images`

Links and images in Markdown can provide the link destination or image source
at the time of use or can define it elsewhere and use a label for reference.
The reference format is convenient for keeping paragraph text clutter-free
and makes it easy to reuse the same URL in multiple places.

There are three kinds of reference links and images:

```markdown
Full: [text][label]
Collapsed: [label][]
Shortcut: [label]

Full: ![text][image]
Collapsed: ![image][]
Shortcut: ![image]

[label]: https://example.com/label
[image]: https://example.com/image
```

A link or image renders correctly when a corresponding label is defined, but
the text displays with brackets if the label is not present. This rule warns
of undefined labels for "full" and "collapsed" reference syntax.

> "Shortcut" syntax is ambiguous and a missing label will not generate an
  error. For example, `[shortcut]` could be a shortcut link or the text
  "shortcut" in brackets.
