/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.step.rollover;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.rollover.RolloverRequest;
import org.opensearch.action.admin.indices.rollover.RolloverResponse;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.action.admin.indices.stats.ShardStats;
import org.opensearch.action.support.DefaultShardOperationFailedException;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.indexmanagement.indexstatemanagement.action.RolloverAction;
import org.opensearch.indexmanagement.indexstatemanagement.step.rollover.AttemptRolloverStep;
import org.opensearch.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.rest.RestStatus;
import org.opensearch.transport.RemoteTransportException;

@kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 *2\u00020\u0001:\u0001*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u000e\u001a\u00020\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJK\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162 \u0010\u0017\u001a\u001c\u0012\u0004\u0012\u00020\u0007\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00060\u0006H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u001b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u001e\u0010\u001c\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\u00160\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016J&\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u00072\n\u0010#\u001a\u00060$j\u0002`%2\b\b\u0002\u0010&\u001a\u00020\u0007H\u0002J\b\u0010'\u001a\u00020\u0016H\u0016J\u0018\u0010(\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006+"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/rollover/AttemptRolloverStep;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "action", "Lorg/opensearch/indexmanagement/indexstatemanagement/action/RolloverAction;", "(Lorg/opensearch/indexmanagement/indexstatemanagement/action/RolloverAction;)V", "info", "", "", "", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "stepStatus", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeRollover", "", "context", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;", "rolloverTarget", "isDataStream", "", "conditions", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;Ljava/lang/String;ZLjava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getIndexStatsOrUpdateInfo", "Lorg/opensearch/action/admin/indices/stats/IndicesStatsResponse;", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRolloverTargetOrUpdateInfo", "Lkotlin/Pair;", "getUpdatedManagedIndexMetadata", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "currentMetadata", "handleException", "indexName", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "isIdempotent", "preCheckIndexAlias", "alias", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nAttemptRolloverStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttemptRolloverStep.kt\norg/opensearch/indexmanagement/indexstatemanagement/step/rollover/AttemptRolloverStep\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,293:1\n14166#2,14:294\n11335#2:312\n11670#2,3:313\n1549#3:308\n1620#3,3:309\n*S KotlinDebug\n*F\n+ 1 AttemptRolloverStep.kt\norg/opensearch/indexmanagement/indexstatemanagement/step/rollover/AttemptRolloverStep\n*L\n79#1:294,14\n193#1:312\n193#1:313,3\n167#1:308\n167#1:309,3\n*E\n"})
public final class AttemptRolloverStep
extends Step {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RolloverAction action;
    private final Logger logger;
    @NotNull
    private Step.StepStatus stepStatus;
    @Nullable
    private Map<String, ? extends Object> info;
    @NotNull
    public static final String name = "attempt_rollover";

    public AttemptRolloverStep(@NotNull RolloverAction action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        super(name, false, 2, null);
        this.action = action;
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.stepStatus = Step.StepStatus.STARTING;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public Object execute(@NotNull Continuation<? super Step> var1_1) {
        block30: {
            if (!(var1_1 instanceof execute.1)) ** GOTO lbl-1000
            var33_2 = var1_1;
            if ((var33_2.label & -2147483648) != 0) {
                var33_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    boolean Z$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ AttemptRolloverStep this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.execute((Continuation<? super Step>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var34_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = this.getContext();
                    if (v0 == null) {
                        return this;
                    }
                    context = v0;
                    indexName = context.getMetadata().getIndex();
                    clusterService = context.getClusterService();
                    v1 = clusterService.state().getMetadata().index(indexName);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"clusterService.state().metadata.index(indexName)");
                    skipRollover = org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt.getRolloverSkip(v1);
                    if (skipRollover) {
                        this.stepStatus = Step.StepStatus.COMPLETED;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)AttemptRolloverStep.Companion.getSkipRolloverMessage(indexName)));
                        return this;
                    }
                    var6_9 = this.getRolloverTargetOrUpdateInfo(context);
                    rolloverTarget = (String)var6_9.component1();
                    isDataStream = (Boolean)var6_9.component2();
                    if (rolloverTarget == null) {
                        return this;
                    }
                    if (clusterService.state().getMetadata().index(indexName).getRolloverInfos().containsKey(rolloverTarget)) {
                        this.stepStatus = Step.StepStatus.COMPLETED;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)AttemptRolloverStep.Companion.getAlreadyRolledOverMessage(indexName, rolloverTarget)));
                        return this;
                    }
                    if (!isDataStream && !this.preCheckIndexAlias(context, rolloverTarget)) {
                        this.stepStatus = Step.StepStatus.FAILED;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)AttemptRolloverStep.Companion.getFailedPreCheckMessage(indexName)));
                        return this;
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = context;
                    $continuation.L$2 = indexName;
                    $continuation.L$3 = clusterService;
                    $continuation.L$4 = rolloverTarget;
                    $continuation.Z$0 = isDataStream;
                    $continuation.label = 1;
                    v2 = this.getIndexStatsOrUpdateInfo(context, (Continuation<? super IndicesStatsResponse>)$continuation);
                    if (v2 == var34_4) {
                        return var34_4;
                    }
                    ** GOTO lbl58
                }
                case 1: {
                    isDataStream = $continuation.Z$0;
                    rolloverTarget = (String)$continuation.L$4;
                    clusterService = (ClusterService)$continuation.L$3;
                    indexName = (String)$continuation.L$2;
                    context = (StepContext)$continuation.L$1;
                    this = (AttemptRolloverStep)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl58:
                    // 2 sources

                    if ((statsResponse = (IndicesStatsResponse)v2) == null) {
                        return this;
                    }
                    indexCreationDate = clusterService.state().metadata().index(indexName).getCreationDate();
                    if (indexCreationDate == -1L) {
                        this.logger.warn(indexName + " had an indexCreationDate=-1L, cannot use for comparison");
                        v3 = TimeValue.timeValueMillis((long)0L);
                    } else {
                        v3 = TimeValue.timeValueMillis((long)(Instant.now().toEpochMilli() - indexCreationDate));
                    }
                    indexAgeTimeValue = v3;
                    v4 = statsResponse.getPrimaries().docs;
                    numDocs = v4 != null ? v4.getCount() : 0L;
                    v5 = statsResponse.getPrimaries().docs;
                    indexSize = new ByteSizeValue(v5 != null ? v5.getTotalSizeInBytes() : 0L);
                    var17_17 = statsResponse.getShards();
                    Intrinsics.checkNotNullExpressionValue((Object)var17_17, (String)"statsResponse.shards");
                    $this$maxByOrNull$iv = var17_17;
                    $i$f$maxByOrNull = false;
                    if ($this$maxByOrNull$iv.length == 0) {
                        v6 = null;
                    } else {
                        maxElem$iv /* !! */  = $this$maxByOrNull$iv[0];
                        lastIndex$iv = ArraysKt.getLastIndex((Object[])$this$maxByOrNull$iv);
                        if (lastIndex$iv == 0) {
                            v6 = maxElem$iv /* !! */ ;
                        } else {
                            it = (ShardStats)maxElem$iv /* !! */ ;
                            $i$a$-maxByOrNull-AttemptRolloverStep$execute$largestPrimaryShard$1 = false;
                            v7 = it.getStats().docs;
                            maxValue$iv = v7 != null ? v7.getTotalSizeInBytes() : 0L;
                            $i$a$-maxByOrNull-AttemptRolloverStep$execute$largestPrimaryShard$1 = new IntRange(1, lastIndex$iv).iterator();
                            while ($i$a$-maxByOrNull-AttemptRolloverStep$execute$largestPrimaryShard$1.hasNext()) {
                                i$iv = $i$a$-maxByOrNull-AttemptRolloverStep$execute$largestPrimaryShard$1.nextInt();
                                e$iv /* !! */  = $this$maxByOrNull$iv[i$iv];
                                it = (ShardStats)e$iv /* !! */ ;
                                $i$a$-maxByOrNull-AttemptRolloverStep$execute$largestPrimaryShard$1 = false;
                                v8 = it.getStats().docs;
                                v$iv = v8 != null ? v8.getTotalSizeInBytes() : 0L;
                                if (maxValue$iv >= v$iv) continue;
                                maxElem$iv /* !! */  = e$iv /* !! */ ;
                                maxValue$iv = v$iv;
                            }
                            v6 = maxElem$iv /* !! */ ;
                        }
                    }
                    largestPrimaryShardSize = new ByteSizeValue((v9 = (largestPrimaryShard = (ShardStats)v6)) != null && (v9 = v9.getStats()) != null && (v9 = v9.docs) != null ? v9.getTotalSizeInBytes() : 0L);
                    v10 = var19_20 = new Pair[4];
                    v11 = 0;
                    v12 = this.action.getMinAge();
                    if (v12 != null) {
                        $i$a$-maxByOrNull-AttemptRolloverStep$execute$largestPrimaryShard$1 = v12;
                        var30_39 = v11;
                        var29_40 = v10;
                        $i$a$-let-AttemptRolloverStep$execute$conditions$1 = false;
                        e$iv /* !! */  = new Pair[]{TuplesKt.to((Object)"condition", (Object)it.toString()), TuplesKt.to((Object)"current", (Object)indexAgeTimeValue.toString()), TuplesKt.to((Object)"creationDate", (Object)Boxing.boxLong((long)indexCreationDate))};
                        var31_41 = TuplesKt.to((Object)"min_index_age", (Object)MapsKt.mapOf((Pair[])e$iv /* !! */ ));
                        v10 = var29_40;
                        v11 = var30_39;
                        v13 = var31_41;
                    } else {
                        v13 = null;
                    }
                    v10[v11] = v13;
                    v14 = var19_20;
                    v15 = 1;
                    v16 = this.action.getMinDocs();
                    if (v16 != null) {
                        it = ((Number)v16).longValue();
                        var30_39 = v15;
                        var29_40 = v14;
                        $i$a$-let-AttemptRolloverStep$execute$conditions$2 = false;
                        var26_36 = new Pair[]{TuplesKt.to((Object)"condition", (Object)Boxing.boxLong((long)it)), TuplesKt.to((Object)"current", (Object)Boxing.boxLong((long)numDocs))};
                        var31_41 = TuplesKt.to((Object)"min_doc_count", (Object)MapsKt.mapOf((Pair[])var26_36));
                        v14 = var29_40;
                        v15 = var30_39;
                        v17 = var31_41;
                    } else {
                        v17 = null;
                    }
                    v14[v15] = v17;
                    v18 = var19_20;
                    v19 = 2;
                    v20 = this.action.getMinSize();
                    if (v20 != null) {
                        it = v20;
                        var30_39 = v19;
                        var29_40 = v18;
                        $i$a$-let-AttemptRolloverStep$execute$conditions$3 = false;
                        var25_32 = new Pair[]{TuplesKt.to((Object)"condition", (Object)it.toString()), TuplesKt.to((Object)"current", (Object)indexSize.toString())};
                        var31_41 = TuplesKt.to((Object)"min_size", (Object)MapsKt.mapOf((Pair[])var25_32));
                        v18 = var29_40;
                        v19 = var30_39;
                        v21 = var31_41;
                    } else {
                        v21 = null;
                    }
                    v18[v19] = v21;
                    v22 = var19_20;
                    v23 = 3;
                    v24 = this.action.getMinPrimaryShardSize();
                    if (v24 != null) {
                        it = v24;
                        var30_39 = v23;
                        var29_40 = v22;
                        $i$a$-let-AttemptRolloverStep$execute$conditions$4 = false;
                        var25_33 = new Pair[]{TuplesKt.to((Object)"condition", (Object)it.toString()), TuplesKt.to((Object)"current", (Object)largestPrimaryShardSize.toString()), TuplesKt.to((Object)"shard", (v25 = largestPrimaryShard) != null && (v25 = v25.getShardRouting()) != null ? Boxing.boxInt((int)v25.id()) : null)};
                        var31_41 = TuplesKt.to((Object)"min_primary_shard_size", (Object)MapsKt.mapOf((Pair[])var25_33));
                        v22 = var29_40;
                        v23 = var30_39;
                        v26 = var31_41;
                    } else {
                        v26 = null;
                    }
                    v22[v23] = v26;
                    conditions = MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])var19_20));
                    Intrinsics.checkNotNullExpressionValue((Object)indexAgeTimeValue, (String)"indexAgeTimeValue");
                    if (!ManagedIndexUtils.evaluateConditions(this.action, indexAgeTimeValue, numDocs, indexSize, largestPrimaryShardSize)) break;
                    this.logger.info(indexName + " rollover conditions evaluated to true [indexCreationDate=" + indexCreationDate + ", numDocs=" + numDocs + ", indexSize=" + indexSize.getBytes() + ", primaryShardSize=" + largestPrimaryShardSize.getBytes() + "]");
                    $continuation.L$0 = this;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.L$3 = null;
                    $continuation.L$4 = null;
                    $continuation.label = 2;
                    v27 = this.executeRollover(context, rolloverTarget, isDataStream != false, conditions, (Continuation<? super Unit>)$continuation);
                    if (v27 == var34_4) {
                        return var34_4;
                    }
                    break block30;
                }
                case 2: {
                    this = (AttemptRolloverStep)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v27 = $result;
                    break block30;
                }
            }
            this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
            var19_20 = new Pair[]{TuplesKt.to((Object)"message", (Object)AttemptRolloverStep.Companion.getPendingMessage(indexName)), TuplesKt.to((Object)"conditions", (Object)conditions)};
            this.info = MapsKt.mapOf((Pair[])var19_20);
        }
        return this;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Pair<String, Boolean> getRolloverTargetOrUpdateInfo(StepContext context) {
        String rolloverTarget;
        String string;
        IndexAbstraction indexAbstraction;
        String indexName = context.getMetadata().getIndex();
        Metadata metadata2 = context.getClusterService().state().metadata();
        IndexAbstraction indexAbstraction2 = indexAbstraction = (IndexAbstraction)metadata2.getIndicesLookup().get(indexName);
        boolean isDataStreamIndex = (indexAbstraction2 != null ? indexAbstraction2.getParentDataStream() : null) != null;
        if (isDataStreamIndex) {
            IndexAbstraction indexAbstraction3 = indexAbstraction;
            string = indexAbstraction3 != null && (indexAbstraction3 = indexAbstraction3.getParentDataStream()) != null ? indexAbstraction3.getName() : null;
        } else {
            IndexMetadata indexMetadata2 = metadata2.index(indexName);
            Intrinsics.checkNotNullExpressionValue((Object)indexMetadata2, (String)"metadata.index(indexName)");
            string = rolloverTarget = org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt.getRolloverAlias(indexMetadata2);
        }
        if (rolloverTarget == null) {
            String message = Companion.getFailedNoValidAliasMessage(indexName);
            this.logger.warn(message);
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)message));
        }
        return TuplesKt.to((Object)rolloverTarget, (Object)isDataStreamIndex);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean preCheckIndexAlias(StepContext context, String alias) {
        String indexName = context.getMetadata().getIndex();
        Metadata metadata2 = context.getClusterService().state().getMetadata();
        Object object = metadata2.index(indexName);
        AliasMetadata indexAlias = object != null && (object = object.getAliases()) != null ? (AliasMetadata)object.get(alias) : null;
        this.logger.debug("Index " + indexName + " has aliases " + indexAlias);
        if (indexAlias == null) {
            return false;
        }
        Boolean isWriteIndex = indexAlias.writeIndex();
        if (!Intrinsics.areEqual((Object)isWriteIndex, (Object)true)) {
            List list;
            Object object2 = (IndexAbstraction)metadata2.getIndicesLookup().get(alias);
            if (object2 != null && (object2 = object2.getIndices()) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IndexMetadata indexMetadata2 = (IndexMetadata)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getIndex());
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
            List aliasIndices = list;
            this.logger.debug("Alias " + alias + " contains indices " + aliasIndices);
            if (aliasIndices != null && aliasIndices.size() > 1) {
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object getIndexStatsOrUpdateInfo(StepContext var1_1, Continuation<? super IndicesStatsResponse> var2_2) {
        if (!(var2_2 instanceof getIndexStatsOrUpdateInfo.1)) ** GOTO lbl-1000
        var24_3 = var2_2;
        if ((var24_3.label & -2147483648) != 0) {
            var24_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AttemptRolloverStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AttemptRolloverStep.access$getIndexStatsOrUpdateInfo(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var25_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                indexName = context.getMetadata().getIndex();
                var5_7 = new String[]{indexName};
                statsRequest = ((IndicesStatsRequest)new IndicesStatsRequest().indices(var5_7)).clear().docs(true);
                $continuation.L$0 = this;
                $continuation.L$1 = indexName;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)context.getClient().admin().indices(), (Function2)new Function2<IndicesAdminClient, ActionListener<IndicesStatsResponse>, Unit>(statsRequest){
                    final /* synthetic */ IndicesStatsRequest $statsRequest;
                    {
                        this.$statsRequest = $statsRequest;
                        super(2);
                    }

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<IndicesStatsResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.stats(this.$statsRequest, it);
                    }
                }, $continuation);
                ** if (v0 != var25_5) goto lbl23
lbl22:
                // 1 sources

                return var25_5;
lbl23:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                indexName = (String)$continuation.L$1;
                this = (AttemptRolloverStep)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl31:
                    // 2 sources

                    if ((statsResponse = (IndicesStatsResponse)v0).getStatus() == RestStatus.OK) {
                        return statsResponse;
                    }
                    message = AttemptRolloverStep.Companion.getFailedEvaluateMessage(indexName);
                    this.logger.warn(message + " - " + statsResponse.getStatus());
                    this.stepStatus = Step.StepStatus.FAILED;
                    var7_13 = new Pair[2];
                    var7_13[0] = TuplesKt.to((Object)"message", (Object)message);
                    var8_14 /* !! */  = statsResponse.getShardFailures();
                    Intrinsics.checkNotNullExpressionValue((Object)var8_14 /* !! */ , (String)"statsResponse.shardFailures");
                    var8_14 /* !! */  = var8_14 /* !! */ ;
                    var21_15 = "shard_failures";
                    var20_16 = 1;
                    var19_17 = var7_13;
                    var18_18 = this;
                    $i$f$map = false;
                    var10_20 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                    $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        var16_26 = (DefaultShardOperationFailedException)item$iv$iv;
                        var22_28 = destination$iv$iv;
                        $i$a$-map-AttemptRolloverStep$getIndexStatsOrUpdateInfo$2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        var22_28.add(OpenSearchExtensionsKt.getUsefulCauseString((DefaultShardOperationFailedException)it));
                    }
                    var22_28 = (List)destination$iv$iv;
                    var19_17[var20_16] = TuplesKt.to((Object)var21_15, (Object)var22_28);
                    var18_18.info = MapsKt.mapOf((Pair[])var7_13);
                }
                catch (RemoteTransportException e) {
                    var5_8 = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)var5_8, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    AttemptRolloverStep.handleException$default(this, indexName, (Exception)var5_8, null, 4, null);
                }
                catch (Exception e) {
                    this.handleException(indexName, e, AttemptRolloverStep.Companion.getFailedEvaluateMessage(indexName));
                }
                return null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object executeRollover(StepContext var1_1, String var2_2, boolean var3_3, Map<String, ? extends Map<String, ? extends Object>> var4_4, Continuation<? super Unit> var5_5) {
        if (!(var5_5 instanceof executeRollover.1)) ** GOTO lbl-1000
        var12_6 = var5_5;
        if ((var12_6.label & -2147483648) != 0) {
            var12_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ AttemptRolloverStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AttemptRolloverStep.access$executeRollover(this.this$0, null, null, false, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                indexName = context.getMetadata().getIndex();
                request = new RolloverRequest(rolloverTarget, null);
                $continuation.L$0 = this;
                $continuation.L$1 = rolloverTarget;
                $continuation.L$2 = conditions;
                $continuation.L$3 = indexName;
                $continuation.Z$0 = isDataStream;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)context.getClient().admin().indices(), (Function2)new Function2<IndicesAdminClient, ActionListener<RolloverResponse>, Unit>(request){
                    final /* synthetic */ RolloverRequest $request;
                    {
                        this.$request = $request;
                        super(2);
                    }

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<RolloverResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.rolloverIndex(this.$request, it);
                    }
                }, $continuation);
                ** if (v0 != var13_8) goto lbl25
lbl24:
                // 1 sources

                return var13_8;
lbl25:
                // 1 sources

                ** GOTO lbl36
            }
            case 1: {
                isDataStream = $continuation.Z$0;
                indexName = (String)$continuation.L$3;
                conditions = (Map)$continuation.L$2;
                rolloverTarget = (String)$continuation.L$1;
                this = (AttemptRolloverStep)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl36:
                    // 2 sources

                    if ((response = (RolloverResponse)v0).isAcknowledged()) {
                        message = isDataStream != false ? AttemptRolloverStep.Companion.getSuccessDataStreamRolloverMessage(rolloverTarget, indexName) : AttemptRolloverStep.Companion.getSuccessMessage(indexName);
                        this.stepStatus = Step.StepStatus.COMPLETED;
                        var10_17 = new Pair[]{TuplesKt.to((Object)"message", (Object)message), conditions.isEmpty() != false ? null : TuplesKt.to((Object)"conditions", (Object)conditions)};
                        this.info = MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])var10_17));
                    } else {
                        if (isDataStream) {
                            v1 = AttemptRolloverStep.Companion.getFailedDataStreamRolloverMessage(rolloverTarget);
                        } else {
                            var10_18 = response.getNewIndex();
                            Intrinsics.checkNotNullExpressionValue((Object)var10_18, (String)"response.newIndex");
                            v1 = AttemptRolloverStep.Companion.getFailedAliasUpdateMessage(indexName, (String)var10_18);
                        }
                        message = v1;
                        this.logger.warn(message);
                        this.stepStatus = Step.StepStatus.FAILED;
                        var10_18 = new Pair[]{TuplesKt.to((Object)"message", (Object)message), conditions.isEmpty() != false ? null : TuplesKt.to((Object)"conditions", (Object)conditions)};
                        this.info = MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])var10_18));
                    }
                }
                catch (RemoteTransportException e) {
                    var8_14 = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)var8_14, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    AttemptRolloverStep.handleException$default(this, indexName, (Exception)var8_14, null, 4, null);
                }
                catch (Exception e) {
                    AttemptRolloverStep.handleException$default(this, indexName, e, null, 4, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData currentMetadata) {
        Intrinsics.checkNotNullParameter((Object)currentMetadata, (String)"currentMetadata");
        StepMetaData stepMetaData = new StepMetaData(this.getName(), this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus);
        boolean bl = Intrinsics.areEqual((Object)currentMetadata.getRolledOver(), (Object)true) ? true : this.stepStatus == Step.StepStatus.COMPLETED;
        Map<String, ? extends Object> map = this.info;
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)currentMetadata, null, null, null, null, null, null, (Boolean)bl, null, null, null, null, (StepMetaData)stepMetaData, null, map, null, (long)0L, (long)0L, (int)120511, null);
    }

    private final void handleException(String indexName, Exception e, String message) {
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)message)};
        Map mutableInfo = MapsKt.mutableMapOf((Pair[])pairArray);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = MapsKt.toMap((Map)mutableInfo);
    }

    static /* synthetic */ void handleException$default(AttemptRolloverStep attemptRolloverStep, String string, Exception exception, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = Companion.getFailedMessage(string);
        }
        attemptRolloverStep.handleException(string, exception, string2);
    }

    public boolean isIdempotent() {
        return false;
    }

    public static final /* synthetic */ Object access$getIndexStatsOrUpdateInfo(AttemptRolloverStep $this, StepContext context, Continuation $completion) {
        return $this.getIndexStatsOrUpdateInfo(context, (Continuation<? super IndicesStatsResponse>)$completion);
    }

    public static final /* synthetic */ Object access$executeRollover(AttemptRolloverStep $this, StepContext context, String rolloverTarget, boolean isDataStream, Map conditions, Continuation $completion) {
        return $this.executeRollover(context, rolloverTarget, isDataStream, conditions, (Continuation<? super Unit>)$completion);
    }

    @kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/rollover/AttemptRolloverStep$Companion;", "", "()V", "name", "", "getAlreadyRolledOverMessage", "index", "alias", "getFailedAliasUpdateMessage", "newIndex", "getFailedDataStreamRolloverMessage", "dataStream", "getFailedEvaluateMessage", "getFailedMessage", "getFailedNoValidAliasMessage", "getFailedPreCheckMessage", "getPendingMessage", "getSkipRolloverMessage", "getSuccessDataStreamRolloverMessage", "getSuccessMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFailedMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to rollover index [index=" + index2 + "]";
        }

        @NotNull
        public final String getFailedAliasUpdateMessage(@NotNull String index2, @NotNull String newIndex) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            Intrinsics.checkNotNullParameter((Object)newIndex, (String)"newIndex");
            return "New index created, but failed to update alias [index=" + index2 + ", newIndex=" + newIndex + "]";
        }

        @NotNull
        public final String getFailedDataStreamRolloverMessage(@NotNull String dataStream) {
            Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
            return "Failed to rollover data stream [data_stream=" + dataStream + "]";
        }

        @NotNull
        public final String getFailedNoValidAliasMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Missing rollover_alias index setting [index=" + index2 + "]";
        }

        @NotNull
        public final String getFailedEvaluateMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to evaluate conditions for rollover [index=" + index2 + "]";
        }

        @NotNull
        public final String getPendingMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Pending rollover of index [index=" + index2 + "]";
        }

        @NotNull
        public final String getSuccessMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Successfully rolled over index [index=" + index2 + "]";
        }

        @NotNull
        public final String getSuccessDataStreamRolloverMessage(@NotNull String dataStream, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Successfully rolled over data stream [data_stream=" + dataStream + " index=" + index2 + "]";
        }

        @NotNull
        public final String getFailedPreCheckMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Missing alias or not the write index when rollover [index=" + index2 + "]";
        }

        @NotNull
        public final String getSkipRolloverMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Skipped rollover action for [index=" + index2 + "]";
        }

        @NotNull
        public final String getAlreadyRolledOverMessage(@NotNull String index2, @NotNull String alias) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
            return "This index has already been rolled over using this alias, treating as a success [index=" + index2 + ", alias=" + alias + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

