/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.http_action.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.performanceanalyzer.commons.config.PluginSettings;
import org.opensearch.performanceanalyzer.config.setting.handler.NodeStatsSettingHandler;
import org.opensearch.performanceanalyzer.config.setting.handler.PerformanceAnalyzerClusterSettingHandler;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;

public class PerformanceAnalyzerClusterConfigAction
extends BaseRestHandler {
    private static final Logger LOG = LogManager.getLogger(PerformanceAnalyzerClusterConfigAction.class);
    public static final String CURRENT = "currentPerformanceAnalyzerClusterState";
    public static final String BATCH_METRICS_RETENTION_PERIOD_MINUTES = "batchMetricsRetentionPeriodMinutes";
    public static final String ENABLED = "enabled";
    public static final String SHARDS_PER_COLLECTION = "shardsPerCollection";
    public static final String PA_CLUSTER_CONFIG_PATH = "/_plugins/_performanceanalyzer/cluster/config";
    public static final String RCA_CLUSTER_CONFIG_PATH = "/_plugins/_performanceanalyzer/rca/cluster/config";
    public static final String LOGGING_CLUSTER_CONFIG_PATH = "/_plugins/_performanceanalyzer/logging/cluster/config";
    public static final String BATCH_METRICS_CLUSTER_CONFIG_PATH = "/_plugins/_performanceanalyzer/batch/cluster/config";
    public static final String THREAD_CONTENTION_MONITORING_CLUSTER_CONFIG_PATH = "/_plugins/_performanceanalyzer/threadContentionMonitoring/cluster/config";
    public static final String LEGACY_PA_CLUSTER_CONFIG_PATH = "/_opendistro/_performanceanalyzer/cluster/config";
    public static final String LEGACY_RCA_CLUSTER_CONFIG_PATH = "/_opendistro/_performanceanalyzer/rca/cluster/config";
    public static final String LEGACY_LOGGING_CLUSTER_CONFIG_PATH = "/_opendistro/_performanceanalyzer/logging/cluster/config";
    public static final String LEGACY_BATCH_METRICS_CLUSTER_CONFIG_PATH = "/_opendistro/_performanceanalyzer/batch/cluster/config";
    private static final List<RestHandler.Route> ROUTES = Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_performanceanalyzer/threadContentionMonitoring/cluster/config"), new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_performanceanalyzer/threadContentionMonitoring/cluster/config")));
    private static final List<RestHandler.ReplacedRoute> REPLACED_ROUTES = Collections.unmodifiableList(Arrays.asList(new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_performanceanalyzer/cluster/config", RestRequest.Method.GET, "/_opendistro/_performanceanalyzer/cluster/config"), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_plugins/_performanceanalyzer/cluster/config", RestRequest.Method.POST, "/_opendistro/_performanceanalyzer/cluster/config"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_performanceanalyzer/rca/cluster/config", RestRequest.Method.GET, "/_opendistro/_performanceanalyzer/rca/cluster/config"), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_plugins/_performanceanalyzer/rca/cluster/config", RestRequest.Method.POST, "/_opendistro/_performanceanalyzer/rca/cluster/config"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_performanceanalyzer/logging/cluster/config", RestRequest.Method.GET, "/_opendistro/_performanceanalyzer/logging/cluster/config"), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_plugins/_performanceanalyzer/logging/cluster/config", RestRequest.Method.POST, "/_opendistro/_performanceanalyzer/logging/cluster/config"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_performanceanalyzer/batch/cluster/config", RestRequest.Method.GET, "/_opendistro/_performanceanalyzer/batch/cluster/config"), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_plugins/_performanceanalyzer/batch/cluster/config", RestRequest.Method.POST, "/_opendistro/_performanceanalyzer/batch/cluster/config")));
    private final PerformanceAnalyzerClusterSettingHandler clusterSettingHandler;
    private final NodeStatsSettingHandler nodeStatsSettingHandler;

    public PerformanceAnalyzerClusterConfigAction(Settings settings, RestController restController, PerformanceAnalyzerClusterSettingHandler clusterSettingHandler, NodeStatsSettingHandler nodeStatsSettingHandler) {
        this.clusterSettingHandler = clusterSettingHandler;
        this.nodeStatsSettingHandler = nodeStatsSettingHandler;
    }

    public String getName() {
        return PerformanceAnalyzerClusterConfigAction.class.getSimpleName();
    }

    public List<RestHandler.Route> routes() {
        return ROUTES;
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return REPLACED_ROUTES;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        request.param("verbose");
        if (request.method() == RestRequest.Method.POST && request.content().length() > 0) {
            Object shardPerCollectionValue;
            Map map = (Map)XContentHelper.convertToMap((BytesReference)request.content(), (boolean)false, (XContentType)XContentType.JSON).v2();
            Object value = map.get(ENABLED);
            LOG.debug("PerformanceAnalyzer:Value (Object) Received as Part of Request: {} current value: {}", value, (Object)this.clusterSettingHandler.getCurrentClusterSettingValue());
            if (value instanceof Boolean) {
                if (request.path().contains(RCA_CLUSTER_CONFIG_PATH) || request.path().contains(LEGACY_RCA_CLUSTER_CONFIG_PATH)) {
                    this.clusterSettingHandler.updateRcaSetting((Boolean)value);
                } else if (request.path().contains(LOGGING_CLUSTER_CONFIG_PATH) || request.path().contains(LEGACY_LOGGING_CLUSTER_CONFIG_PATH)) {
                    this.clusterSettingHandler.updateLoggingSetting((Boolean)value);
                } else if (request.path().contains(BATCH_METRICS_CLUSTER_CONFIG_PATH) || request.path().contains(LEGACY_BATCH_METRICS_CLUSTER_CONFIG_PATH)) {
                    this.clusterSettingHandler.updateBatchMetricsSetting((Boolean)value);
                } else if (request.path().contains(THREAD_CONTENTION_MONITORING_CLUSTER_CONFIG_PATH)) {
                    this.clusterSettingHandler.updateThreadContentionMonitoringSetting((Boolean)value);
                } else {
                    this.clusterSettingHandler.updatePerformanceAnalyzerSetting((Boolean)value);
                }
            }
            if (map.containsKey(SHARDS_PER_COLLECTION) && (shardPerCollectionValue = map.get(SHARDS_PER_COLLECTION)) instanceof Integer) {
                this.nodeStatsSettingHandler.updateNodeStatsSetting((Integer)shardPerCollectionValue);
            }
        }
        return channel -> {
            try {
                XContentBuilder builder = channel.newBuilder();
                builder.startObject();
                builder.field(CURRENT, request.paramAsBoolean("verbose", false) ? this.clusterSettingHandler.getCurrentClusterSettingValueVerbose() : Integer.valueOf(this.clusterSettingHandler.getCurrentClusterSettingValue()));
                builder.field(SHARDS_PER_COLLECTION, this.nodeStatsSettingHandler.getNodeStatsSetting());
                builder.field(BATCH_METRICS_RETENTION_PERIOD_MINUTES, PluginSettings.instance().getBatchMetricsRetentionPeriodMinutes());
                builder.endObject();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
            }
            catch (IOException ioe) {
                LOG.error("Error sending response", (Throwable)ioe);
            }
        };
    }
}

