/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import jakarta.servlet.http.HttpUpgradeHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.CompressionConfig;
import org.apache.coyote.ContinueResponseTiming;
import org.apache.coyote.Processor;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.UpgradeToken;
import org.apache.coyote.http11.Http11Processor;
import org.apache.coyote.http11.upgrade.InternalHttpUpgradeHandler;
import org.apache.coyote.http11.upgrade.UpgradeGroupInfo;
import org.apache.coyote.http11.upgrade.UpgradeProcessorExternal;
import org.apache.coyote.http11.upgrade.UpgradeProcessorInternal;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.Util;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractHttp11Protocol<S>
extends AbstractProtocol<S> {
    protected static final StringManager sm = StringManager.getManager(AbstractHttp11Protocol.class);
    private final CompressionConfig compressionConfig = new CompressionConfig();
    private ContinueResponseTiming continueResponseTiming = ContinueResponseTiming.IMMEDIATELY;
    private boolean useKeepAliveResponseHeader = true;
    private String relaxedPathChars = null;
    private String relaxedQueryChars = null;
    private boolean allowHostHeaderMismatch = false;
    private boolean rejectIllegalHeader = true;
    private int maxSavePostSize = 4096;
    private int maxHttpHeaderSize = 8192;
    private int maxHttpRequestHeaderSize = -1;
    private int maxHttpResponseHeaderSize = -1;
    private int connectionUploadTimeout = 300000;
    private boolean disableUploadTimeout = true;
    private Pattern restrictedUserAgents = null;
    private String server;
    private boolean serverRemoveAppProvidedValues = false;
    private int maxTrailerSize = 8192;
    private int maxExtensionSize = 8192;
    private int maxSwallowSize = 0x200000;
    private boolean secure;
    private Set<String> allowedTrailerHeaders = ConcurrentHashMap.newKeySet();
    private final List<UpgradeProtocol> upgradeProtocols = new ArrayList<UpgradeProtocol>();
    private final Map<String, UpgradeProtocol> httpUpgradeProtocols = new HashMap<String, UpgradeProtocol>();
    private final Map<String, UpgradeProtocol> negotiatedProtocols = new HashMap<String, UpgradeProtocol>();
    private final Map<String, UpgradeGroupInfo> upgradeProtocolGroupInfos = new ConcurrentHashMap<String, UpgradeGroupInfo>();

    public AbstractHttp11Protocol(AbstractEndpoint<S, ?> abstractEndpoint) {
        super(abstractEndpoint);
        this.setConnectionTimeout(60000);
    }

    @Override
    public void init() throws Exception {
        for (UpgradeProtocol upgradeProtocol : this.upgradeProtocols) {
            this.configureUpgradeProtocol(upgradeProtocol);
        }
        super.init();
        for (UpgradeProtocol upgradeProtocol : this.upgradeProtocols) {
            upgradeProtocol.setHttp11Protocol(this);
        }
    }

    @Override
    public void destroy() throws Exception {
        ObjectName objectName = this.getGlobalRequestProcessorMBeanName();
        if (objectName != null) {
            Registry registry = Registry.getRegistry(null, null);
            ObjectName objectName2 = new ObjectName(objectName.getCanonicalName() + ",Upgrade=*");
            Set<ObjectInstance> set = registry.getMBeanServer().queryMBeans(objectName2, null);
            for (ObjectInstance objectInstance : set) {
                registry.unregisterComponent(objectInstance.getObjectName());
            }
        }
        super.destroy();
    }

    @Override
    protected String getProtocolName() {
        return "Http";
    }

    @Override
    protected AbstractEndpoint<S, ?> getEndpoint() {
        return super.getEndpoint();
    }

    public String getContinueResponseTiming() {
        return this.continueResponseTiming.toString();
    }

    public void setContinueResponseTiming(String string) {
        this.continueResponseTiming = ContinueResponseTiming.fromString(string);
    }

    public ContinueResponseTiming getContinueResponseTimingInternal() {
        return this.continueResponseTiming;
    }

    public boolean getUseKeepAliveResponseHeader() {
        return this.useKeepAliveResponseHeader;
    }

    public void setUseKeepAliveResponseHeader(boolean bl) {
        this.useKeepAliveResponseHeader = bl;
    }

    public String getRelaxedPathChars() {
        return this.relaxedPathChars;
    }

    public void setRelaxedPathChars(String string) {
        this.relaxedPathChars = string;
    }

    public String getRelaxedQueryChars() {
        return this.relaxedQueryChars;
    }

    public void setRelaxedQueryChars(String string) {
        this.relaxedQueryChars = string;
    }

    @Deprecated
    public boolean getAllowHostHeaderMismatch() {
        return this.allowHostHeaderMismatch;
    }

    @Deprecated
    public void setAllowHostHeaderMismatch(boolean bl) {
        this.allowHostHeaderMismatch = bl;
    }

    @Deprecated
    public boolean getRejectIllegalHeader() {
        return this.rejectIllegalHeader;
    }

    @Deprecated
    public void setRejectIllegalHeader(boolean bl) {
        this.rejectIllegalHeader = bl;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int n) {
        this.maxSavePostSize = n;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int n) {
        this.maxHttpHeaderSize = n;
    }

    public int getMaxHttpRequestHeaderSize() {
        return this.maxHttpRequestHeaderSize == -1 ? this.getMaxHttpHeaderSize() : this.maxHttpRequestHeaderSize;
    }

    public void setMaxHttpRequestHeaderSize(int n) {
        this.maxHttpRequestHeaderSize = n;
    }

    public int getMaxHttpResponseHeaderSize() {
        return this.maxHttpResponseHeaderSize == -1 ? this.getMaxHttpHeaderSize() : this.maxHttpResponseHeaderSize;
    }

    public void setMaxHttpResponseHeaderSize(int n) {
        this.maxHttpResponseHeaderSize = n;
    }

    public int getConnectionUploadTimeout() {
        return this.connectionUploadTimeout;
    }

    public void setConnectionUploadTimeout(int n) {
        this.connectionUploadTimeout = n;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean bl) {
        this.disableUploadTimeout = bl;
    }

    public void setCompression(String string) {
        this.compressionConfig.setCompression(string);
    }

    public String getCompression() {
        return this.compressionConfig.getCompression();
    }

    protected int getCompressionLevel() {
        return this.compressionConfig.getCompressionLevel();
    }

    public String getNoCompressionUserAgents() {
        return this.compressionConfig.getNoCompressionUserAgents();
    }

    protected Pattern getNoCompressionUserAgentsPattern() {
        return this.compressionConfig.getNoCompressionUserAgentsPattern();
    }

    public void setNoCompressionUserAgents(String string) {
        this.compressionConfig.setNoCompressionUserAgents(string);
    }

    public String getCompressibleMimeType() {
        return this.compressionConfig.getCompressibleMimeType();
    }

    public void setCompressibleMimeType(String string) {
        this.compressionConfig.setCompressibleMimeType(string);
    }

    public String[] getCompressibleMimeTypes() {
        return this.compressionConfig.getCompressibleMimeTypes();
    }

    public int getCompressionMinSize() {
        return this.compressionConfig.getCompressionMinSize();
    }

    public void setCompressionMinSize(int n) {
        this.compressionConfig.setCompressionMinSize(n);
    }

    public boolean useCompression(Request request, Response response) {
        return this.compressionConfig.useCompression(request, response);
    }

    public String getRestrictedUserAgents() {
        if (this.restrictedUserAgents == null) {
            return null;
        }
        return this.restrictedUserAgents.toString();
    }

    protected Pattern getRestrictedUserAgentsPattern() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String string) {
        this.restrictedUserAgents = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public boolean getServerRemoveAppProvidedValues() {
        return this.serverRemoveAppProvidedValues;
    }

    public void setServerRemoveAppProvidedValues(boolean bl) {
        this.serverRemoveAppProvidedValues = bl;
    }

    public int getMaxTrailerSize() {
        return this.maxTrailerSize;
    }

    public void setMaxTrailerSize(int n) {
        this.maxTrailerSize = n;
    }

    public int getMaxExtensionSize() {
        return this.maxExtensionSize;
    }

    public void setMaxExtensionSize(int n) {
        this.maxExtensionSize = n;
    }

    public int getMaxSwallowSize() {
        return this.maxSwallowSize;
    }

    public void setMaxSwallowSize(int n) {
        this.maxSwallowSize = n;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public void setAllowedTrailerHeaders(String string) {
        HashSet<String> hashSet = new HashSet<String>(this.allowedTrailerHeaders);
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(",")) {
                String string3 = string2.trim().toLowerCase(Locale.ENGLISH);
                if (hashSet.contains(string3)) {
                    hashSet.remove(string3);
                    continue;
                }
                this.allowedTrailerHeaders.add(string3);
            }
            this.allowedTrailerHeaders.removeAll(hashSet);
        }
    }

    protected Set<String> getAllowedTrailerHeadersInternal() {
        return this.allowedTrailerHeaders;
    }

    public boolean isTrailerHeaderAllowed(String string) {
        return this.allowedTrailerHeaders.contains(string);
    }

    public String getAllowedTrailerHeaders() {
        ArrayList<String> arrayList = new ArrayList<String>(this.allowedTrailerHeaders);
        return StringUtils.join(arrayList);
    }

    public void addAllowedTrailerHeader(String string) {
        if (string != null) {
            this.allowedTrailerHeaders.add(string.trim().toLowerCase(Locale.ENGLISH));
        }
    }

    public void removeAllowedTrailerHeader(String string) {
        if (string != null) {
            this.allowedTrailerHeaders.remove(string.trim().toLowerCase(Locale.ENGLISH));
        }
    }

    @Override
    public void addUpgradeProtocol(UpgradeProtocol upgradeProtocol) {
        this.upgradeProtocols.add(upgradeProtocol);
    }

    @Override
    public UpgradeProtocol[] findUpgradeProtocols() {
        return this.upgradeProtocols.toArray(new UpgradeProtocol[0]);
    }

    private void configureUpgradeProtocol(UpgradeProtocol upgradeProtocol) {
        String string;
        String string2 = upgradeProtocol.getHttpUpgradeName(this.getEndpoint().isSSLEnabled());
        boolean bl = false;
        if (string2 != null && string2.length() > 0) {
            this.httpUpgradeProtocols.put(string2, upgradeProtocol);
            bl = true;
            this.getLog().info((Object)sm.getString("abstractHttp11Protocol.httpUpgradeConfigured", new Object[]{this.getName(), string2}));
        }
        if ((string = upgradeProtocol.getAlpnName()) != null && string.length() > 0) {
            if (this.getEndpoint().isSSLEnabled()) {
                this.negotiatedProtocols.put(string, upgradeProtocol);
                this.getEndpoint().addNegotiatedProtocol(string);
                this.getLog().info((Object)sm.getString("abstractHttp11Protocol.alpnConfigured", new Object[]{this.getName(), string}));
            } else if (!bl) {
                this.getLog().error((Object)sm.getString("abstractHttp11Protocol.alpnWithNoAlpn", new Object[]{upgradeProtocol.getClass().getName(), string, this.getName()}));
            }
        }
    }

    @Override
    public UpgradeProtocol getNegotiatedProtocol(String string) {
        return this.negotiatedProtocols.get(string);
    }

    @Override
    public UpgradeProtocol getUpgradeProtocol(String string) {
        return this.httpUpgradeProtocols.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeGroupInfo getUpgradeGroupInfo(String string) {
        if (string == null) {
            return null;
        }
        UpgradeGroupInfo upgradeGroupInfo = this.upgradeProtocolGroupInfos.get(string);
        if (upgradeGroupInfo == null) {
            Map<String, UpgradeGroupInfo> map = this.upgradeProtocolGroupInfos;
            synchronized (map) {
                upgradeGroupInfo = this.upgradeProtocolGroupInfos.get(string);
                if (upgradeGroupInfo == null) {
                    upgradeGroupInfo = new UpgradeGroupInfo();
                    this.upgradeProtocolGroupInfos.put(string, upgradeGroupInfo);
                    ObjectName objectName = this.getONameForUpgrade(string);
                    if (objectName != null) {
                        try {
                            Registry.getRegistry(null, null).registerComponent((Object)upgradeGroupInfo, objectName, null);
                        }
                        catch (Exception exception) {
                            this.getLog().warn((Object)sm.getString("abstractHttp11Protocol.upgradeJmxRegistrationFail"), (Throwable)exception);
                            upgradeGroupInfo = null;
                        }
                    }
                }
            }
        }
        return upgradeGroupInfo;
    }

    public ObjectName getONameForUpgrade(String string) {
        ObjectName objectName = null;
        ObjectName objectName2 = this.getGlobalRequestProcessorMBeanName();
        if (objectName2 != null) {
            StringBuilder stringBuilder = new StringBuilder(objectName2.getCanonicalName());
            stringBuilder.append(",Upgrade=");
            if (Util.objectNameValueNeedsQuote(string)) {
                stringBuilder.append(ObjectName.quote(string));
            } else {
                stringBuilder.append(string);
            }
            try {
                objectName = new ObjectName(stringBuilder.toString());
            }
            catch (Exception exception) {
                this.getLog().warn((Object)sm.getString("abstractHttp11Protocol.upgradeJmxNameFail"), (Throwable)exception);
            }
        }
        return objectName;
    }

    public boolean isSSLEnabled() {
        return this.getEndpoint().isSSLEnabled();
    }

    public void setSSLEnabled(boolean bl) {
        this.getEndpoint().setSSLEnabled(bl);
    }

    public boolean getUseSendfile() {
        return this.getEndpoint().getUseSendfile();
    }

    public void setUseSendfile(boolean bl) {
        this.getEndpoint().setUseSendfile(bl);
    }

    public int getMaxKeepAliveRequests() {
        return this.getEndpoint().getMaxKeepAliveRequests();
    }

    public void setMaxKeepAliveRequests(int n) {
        this.getEndpoint().setMaxKeepAliveRequests(n);
    }

    public String getDefaultSSLHostConfigName() {
        return this.getEndpoint().getDefaultSSLHostConfigName();
    }

    public void setDefaultSSLHostConfigName(String string) {
        this.getEndpoint().setDefaultSSLHostConfigName(string);
    }

    @Override
    public void addSslHostConfig(SSLHostConfig sSLHostConfig) {
        this.getEndpoint().addSslHostConfig(sSLHostConfig);
    }

    @Override
    public SSLHostConfig[] findSslHostConfigs() {
        return this.getEndpoint().findSslHostConfigs();
    }

    public void reloadSslHostConfigs() {
        this.getEndpoint().reloadSslHostConfigs();
    }

    public void reloadSslHostConfig(String string) {
        this.getEndpoint().reloadSslHostConfig(string);
    }

    @Override
    protected Processor createProcessor() {
        Http11Processor http11Processor = new Http11Processor(this, this.adapter);
        return http11Processor;
    }

    @Override
    protected Processor createUpgradeProcessor(SocketWrapperBase<?> socketWrapperBase, UpgradeToken upgradeToken) {
        HttpUpgradeHandler httpUpgradeHandler = upgradeToken.getHttpUpgradeHandler();
        if (httpUpgradeHandler instanceof InternalHttpUpgradeHandler) {
            return new UpgradeProcessorInternal(socketWrapperBase, upgradeToken, this.getUpgradeGroupInfo(upgradeToken.getProtocol()));
        }
        return new UpgradeProcessorExternal(socketWrapperBase, upgradeToken, this.getUpgradeGroupInfo(upgradeToken.getProtocol()));
    }
}

