# `MD049` - Emphasis style should be consistent

Tags: `emphasis`

Aliases: `emphasis-style`

Parameters:

- `style`: Emphasis style (`string`, default `consistent`, values `asterisk` /
  `consistent` / `underscore`)

Fixable: Some violations can be fixed by tooling

This rule is triggered when the symbols used in the document for emphasis do not
match the configured emphasis style:

```markdown
*Text*
_Text_
```

To fix this issue, use the configured emphasis style throughout the document:

```markdown
*Text*
*Text*
```

The configured emphasis style can be a specific symbol to use ("asterisk",
"underscore"), or can require that usage be consistent within the document.

Rationale: Consistent formatting makes it easier to understand a document.
