/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.logo;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.g2d.UGraphicG2d;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.logo.TinyJavaLogo;
import net.sourceforge.plantuml.logo.TurtleGraphicsPane;
import net.sourceforge.plantuml.png.PngIO;

public class PSystemLogo
extends AbstractPSystem {
    private final List<String> lines = new ArrayList<String>();

    public PSystemLogo(UmlSource source) {
        super(source);
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        int width = 640;
        int height = 480;
        StringBounder stringBounder = FileFormat.PNG.getDefaultStringBounder();
        EmptyImageBuilder builder = new EmptyImageBuilder(fileFormat.getWatermark(), 640, 480, Color.WHITE, stringBounder);
        BufferedImage im = builder.getBufferedImage();
        UGraphicG2d ug = new UGraphicG2d(HColors.WHITE, ColorMapper.IDENTITY, stringBounder, builder.getGraphics2D(), 1.0, FileFormat.PNG);
        ug.setBufferedImage(im);
        TurtleGraphicsPane turtleGraphicsPane = new TurtleGraphicsPane(640, 480);
        TinyJavaLogo tinyJavaLogo = new TinyJavaLogo(turtleGraphicsPane);
        for (String line : this.lines) {
            tinyJavaLogo.doCommandLine(line);
        }
        turtleGraphicsPane.paint(ug);
        PngIO.write((RenderedImage)im, ColorMapper.IDENTITY, os, null, 96);
        return new ImageDataSimple(im.getWidth(), im.getHeight());
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Logo)");
    }

    public void doCommandLine(String line) {
        this.lines.add(line);
    }
}

