/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;

public class MethodGroupExpression
extends Expression {
    public static final Role<Expression> CLOSURE_ARGUMENT_RULE = new Role<Expression>("ClosureArgument", Expression.class, Expression.NULL);
    public static final TokenRole DOUBLE_COLON_ROLE = new TokenRole("::", 2);

    public MethodGroupExpression(int offset, Expression target, String methodName) {
        super(offset);
        this.setTarget(target);
        this.setMethodName(methodName);
    }

    public final AstNodeCollection<Expression> getClosureArguments() {
        return this.getChildrenByRole(CLOSURE_ARGUMENT_RULE);
    }

    public final JavaTokenNode getDoubleColonToken() {
        return this.getChildByRole(DOUBLE_COLON_ROLE);
    }

    public final String getMethodName() {
        return this.getChildByRole(Roles.IDENTIFIER).getName();
    }

    public final void setMethodName(String name) {
        this.setChildByRole(Roles.IDENTIFIER, Identifier.create(name));
    }

    public final Identifier getMethodNameToken() {
        return this.getChildByRole(Roles.IDENTIFIER);
    }

    public final void setMethodNameToken(Identifier token) {
        this.setChildByRole(Roles.IDENTIFIER, token);
    }

    public final Expression getTarget() {
        return this.getChildByRole(Roles.TARGET_EXPRESSION);
    }

    public final void setTarget(Expression value) {
        this.setChildByRole(Roles.TARGET_EXPRESSION, value);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitMethodGroupExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        return false;
    }

    @Override
    public boolean isReference() {
        return true;
    }
}

