/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.imports.wizard;

import java.net.URI;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.protege.editor.owl.ui.ontology.imports.wizard.ImportInfo;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class ImportLocationOptionsPanel
extends JPanel {
    private ImportInfo info;
    private JRadioButton ontologyIDButton;
    private JRadioButton versionIDButton;
    private JRadioButton physicalIDButton;
    private JRadioButton userInputButton;
    private JTextField uriField;
    private int optionsCount;

    public ImportLocationOptionsPanel(ImportInfo info) {
        boolean useVersionButton;
        this.info = info;
        OWLOntologyID id = info.getOntologyID();
        IRI physicalLocation = IRI.create((URI)info.getPhysicalLocation());
        ButtonGroup bg = new ButtonGroup();
        this.setLayout(new BoxLayout(this, 1));
        this.optionsCount = 0;
        if (id != null && !id.isAnonymous()) {
            this.ontologyIDButton = new JRadioButton("Import using the ontology name: " + id.getOntologyIRI().get());
            this.ontologyIDButton.setAlignmentX(0.0f);
            this.add(this.ontologyIDButton);
            bg.add(this.ontologyIDButton);
            ++this.optionsCount;
        }
        boolean bl = useVersionButton = id.getVersionIRI().isPresent() && !((IRI)id.getVersionIRI().get()).equals(id.getOntologyIRI().get());
        if (useVersionButton) {
            this.versionIDButton = new JRadioButton("Import using the ontology version (Recommended): " + id.getVersionIRI().get());
            this.versionIDButton.setAlignmentX(0.0f);
            this.add(this.versionIDButton);
            bg.add(this.versionIDButton);
            ++this.optionsCount;
        }
        if (id.isAnonymous() || !physicalLocation.equals(id.getOntologyIRI().get()) && (id.getVersionIRI().isPresent() || !physicalLocation.equals(id.getVersionIRI().get())) && !"file".equals(physicalLocation.getScheme())) {
            this.physicalIDButton = new JRadioButton("Import using the supplied physical URI (Not Recommended): " + physicalLocation);
            this.physicalIDButton.setAlignmentX(0.0f);
            this.add(this.physicalIDButton);
            bg.add(this.physicalIDButton);
            ++this.optionsCount;
        }
        if (this.optionsCount == 1) {
            this.add(new JLabel("Only the one option is available - nothing to select."));
        }
        if (this.optionsCount == 0) {
            this.userInputButton = new JRadioButton("Import using the usr supplied URI (Discouraged)");
            this.userInputButton.setAlignmentX(0.0f);
            this.add(this.userInputButton);
            bg.add(this.userInputButton);
            this.uriField = new JTextField();
            this.uriField.setAlignmentX(0.0f);
            this.uriField.setEnabled(false);
            this.userInputButton.addActionListener(e -> this.uriField.setEnabled(this.userInputButton.isSelected()));
            this.add(this.uriField);
            ++this.optionsCount;
        }
        if (this.versionIDButton != null) {
            this.versionIDButton.setSelected(true);
        } else if (this.ontologyIDButton != null) {
            this.ontologyIDButton.setSelected(true);
        } else if (this.physicalIDButton != null) {
            this.physicalIDButton.setSelected(true);
        } else {
            this.userInputButton.setSelected(true);
            this.uriField.setEnabled(true);
        }
    }

    public void setImportLocation() {
        OWLOntologyID id = this.info.getOntologyID();
        URI physicalLocation = this.info.getPhysicalLocation();
        if (this.ontologyIDButton != null && this.ontologyIDButton.isSelected()) {
            this.info.setImportLocation((IRI)id.getOntologyIRI().get());
        } else if (this.versionIDButton != null && this.versionIDButton.isSelected()) {
            this.info.setImportLocation((IRI)id.getVersionIRI().get());
        } else {
            this.info.setImportLocation(IRI.create((URI)physicalLocation));
        }
    }

    public boolean isPanelNeeded() {
        return this.optionsCount > 1;
    }
}

