<!--
title: Serverless - Apache OpenWhisk Documentation
menuText: OpenWhisk
menuOrder: 10
layout: Doc
-->

<!-- DOCS-SITE-LINK:START automatically generated  -->

### [Read this on the main serverless docs site](https://www.serverless.com/framework/docs/)

<!-- DOCS-SITE-LINK:END -->

# Apache OpenWhisk Provider Documentation

Welcome to the Serverless Apache OpenWhisk documentation!

If you have any questions, [search the forums](https://forum.serverless.com?utm_source=framework-docs) or [start your own thread](https://forum.serverless.com?utm_source=framework-docs)

**Note:** [Apache OpenWhisk system credentials](./guide/credentials.md) are required for using serverless + openwhisk.

<div class="docsSections">
  <div class="docsSection">
    <div class="docsSectionSubHeader">
      <h4>Guides</h4>
    </div>
    <div class="docsProviderItems">
      <ul>
        <li><a href="./guide/intro.md">Intro</a></li>
        <li><a href="./guide/quick-start.md">Quickstart</a></li>
        <li><a href="./guide/installation.md">Installation</a></li>
        <li><a href="./guide/credentials.md">Credentials</a></li>
        <li><a href="./guide/services.md">Services</a></li>
        <li><a href="./guide/functions.md">Functions</a></li>
        <li><a href="./guide/events.md">Events</a></li>
        <li><a href="./guide/deploying.md">Deploying</a></li>
        <li><a href="./guide/testing.md">Testing</a></li>
        <li><a href="./guide/variables.md">Variables</a></li>
        <li><a href="./guide/packaging.md">Packaging</a></li>
        <li><a href="./guide/plugins.md">Plugins</a></li>
        <li><a href="./guide/web-actions.md">Web Actions</a></li>
        <li><a href="./guide/workflow.md">Workflow</a></li>
        <li><a href="./guide/serverless.yml.md">Serverless.yml</a></li>
      </ul>
    </div>
  </div>

  <div class="docsSection">
    <div class="docsSectionSubHeader">
      <h4>CLI References</h4>
    </div>
    <div class="docsProviderItems">
      <ul>
        <li><a href="./cli-reference/config-credentials.md">Config Credentials</a></li>
        <li><a href="./cli-reference/create.md">Create</a></li>
        <li><a href="./cli-reference/install.md">Install</a></li>
        <li><a href="./cli-reference/deploy.md">Deploy</a></li>
        <li><a href="./cli-reference/deploy-function.md">Deploy Function</a></li>
        <li><a href="./cli-reference/invoke.md">Invoke</a></li>
        <li><a href="./cli-reference/invoke-local.md">Invoke Local</a></li>
        <li><a href="./cli-reference/login.md">Login</a></li>
        <li><a href="./cli-reference/logs.md">Logs</a></li>
        <li><a href="./cli-reference/info.md">Info</a></li>
        <li><a href="./cli-reference/remove.md">Remove</a></li>
        <li><a href="./cli-reference/plugin-list.md">Plugin List</a></li>
        <li><a href="./cli-reference/plugin-search.md">Plugin Search</a></li>
        <li><a href="./cli-reference/plugin-install.md">Plugin Install</a></li>
        <li><a href="./cli-reference/plugin-uninstall.md">Plugin Uninstall</a></li>
        <li><a href="./cli-reference/print.md">Print</a></li>
        <li><a href="./cli-reference/slstats.md">Serverless Stats</a></li>
      </ul>
    </div>
  </div>

  <div class="docsSection">
    <div class="docsSectionSubHeader">
      <h4>Events</h4>
    </div>
    <div class="docsProviderItems">
      <ul>
        <li><a href="./events/apigateway.md">API Gateway</a></li>
        <li><a href="./events/cloudant.md">Cloudant DB</a></li>
        <li><a href="./events/messagehub.md">Message Hub</a></li>
        <li><a href="./events/schedule.md">Schedule</a></li>
        <li><a href="./events/triggers.md">Triggers</a></li>
      </ul>
    </div>
  </div>

  <div class="docsSection">
    <div class="docsSectionSubHeader">
      <h4>Examples</h4>
    </div>
    <div>
      <div class="docsProviderItems">
        <ul>
          <li><a href="./examples/hello-world">Hello World</a></li>
        </ul>
      </div>
    </div>
  </div>
</div>
