/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings.convertors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.settings.Env;
import org.netbeans.modules.settings.convertors.XMLSettingsSupport;
import org.netbeans.spi.settings.Convertor;
import org.netbeans.spi.settings.Saver;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLPropertiesConvertor
extends Convertor
implements PropertyChangeListener {
    public static final String EA_PREVENT_STORING = "xmlproperties.preventStoring";
    public static final String EA_IGNORE_CHANGES = "xmlproperties.ignoreChanges";
    private FileObject providerFO;
    private Set ignoreProperites;
    private Saver saver;
    private static final String INDENT = "    ";
    private String instanceClass = null;

    public static Convertor create(FileObject fileObject) {
        return new XMLPropertiesConvertor(fileObject);
    }

    public XMLPropertiesConvertor(FileObject fileObject) {
        this.providerFO = fileObject;
    }

    @Override
    public Object read(java.io.Reader reader) throws IOException, ClassNotFoundException {
        Object object = this.defaultInstanceCreate();
        return this.readSetting(reader, object);
    }

    @Override
    public void write(Writer writer, Object object) throws IOException {
        Object object2;
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + XMLSettingsSupport.LINE_SEPARATOR);
        writer.write("<!DOCTYPE properties PUBLIC \"");
        FileObject fileObject = Env.findEntityRegistration(this.providerFO);
        if (fileObject == null) {
            fileObject = this.providerFO;
        }
        if ((object2 = fileObject.getAttribute("hint.originalPublicID")) == null || !(object2 instanceof String)) {
            throw new IOException("missing or invalid attribute: hint.originalPublicID, provider: " + fileObject);
        }
        writer.write((String)object2);
        writer.write("\" \"http://www.netbeans.org/dtds/properties-1_0.dtd\">" + XMLSettingsSupport.LINE_SEPARATOR);
        writer.write("<properties>" + XMLSettingsSupport.LINE_SEPARATOR);
        Properties properties = XMLPropertiesConvertor.getProperties(object);
        if (properties != null && !properties.isEmpty()) {
            XMLPropertiesConvertor.writeProperties(writer, properties);
        }
        writer.write("</properties>" + XMLSettingsSupport.LINE_SEPARATOR);
    }

    @Override
    public void registerSaver(Object object, Saver saver) {
        if (this.saver != null) {
            XMLSettingsSupport.err.log(Level.WARNING, "Already registered Saver: {0} for settings object: {1}", new Object[]{saver.getClass().getCanonicalName(), object.getClass().getCanonicalName()});
            return;
        }
        try {
            Method method = object.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            method.invoke(object, this);
            this.saver = saver;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            XMLSettingsSupport.err.warning("ObjectChangesNotifier: NoSuchMethodException: " + object.getClass().getName() + ".addPropertyChangeListener");
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
    }

    @Override
    public void unregisterSaver(Object object, Saver saver) {
        if (this.saver == null) {
            return;
        }
        if (this.saver != saver) {
            XMLSettingsSupport.err.log(Level.WARNING, "Unregistering unknown Saver: {0} for settings object: {1}", new Object[]{saver.getClass().getCanonicalName(), object.getClass().getCanonicalName()});
            return;
        }
        try {
            Method method = object.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
            method.invoke(object, this);
            this.saver = null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            XMLSettingsSupport.err.fine("ObjectChangesNotifier: NoSuchMethodException: " + object.getClass().getName() + ".removePropertyChangeListener");
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.saver == null || this.ignoreChange(propertyChangeEvent)) {
            return;
        }
        if (this.acceptSave()) {
            try {
                this.saver.requestSave();
            }
            catch (IOException iOException) {
                Logger.getLogger(XMLPropertiesConvertor.class.getName()).log(Level.WARNING, null, iOException);
            }
        } else {
            this.saver.markDirty();
        }
    }

    private boolean ignoreChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null || propertyChangeEvent.getPropertyName() == null) {
            return true;
        }
        if (this.ignoreProperites == null) {
            this.ignoreProperites = Env.parseAttribute(this.providerFO.getAttribute(EA_IGNORE_CHANGES));
        }
        if (this.ignoreProperites.contains(propertyChangeEvent.getPropertyName())) {
            return true;
        }
        return this.ignoreProperites.contains("all");
    }

    private boolean acceptSave() {
        Object object = this.providerFO.getAttribute(EA_PREVENT_STORING);
        if (object == null) {
            return true;
        }
        if (object instanceof Boolean) {
            return (Boolean)object == false;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object) == false;
        }
        return true;
    }

    private Object defaultInstanceCreate() throws IOException, ClassNotFoundException {
        Object object = this.providerFO.getAttribute("settings.instanceCreate");
        if (object != null) {
            return object;
        }
        Class clazz = this.getInstanceClass();
        try {
            return XMLSettingsSupport.newInstance(clazz);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Cannot create instance of " + clazz.getName());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    private Class getInstanceClass() throws IOException, ClassNotFoundException {
        if (this.instanceClass == null) {
            Object object = this.providerFO.getAttribute("settings.instanceClass");
            if (object == null || !(object instanceof String)) {
                throw new IllegalStateException("missing or invalid ea attribute: settings.instanceClass");
            }
            this.instanceClass = (String)object;
        }
        return ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass(this.instanceClass);
    }

    private Object readSetting(java.io.Reader reader, Object object) throws IOException {
        try {
            Method method = object.getClass().getDeclaredMethod("readProperties", Properties.class);
            method.setAccessible(true);
            Reader reader2 = new Reader();
            reader2.parse(reader);
            method.setAccessible(true);
            Object object2 = method.invoke(object, reader2.getProperties());
            if (object2 == null) {
                object2 = object;
            }
            return object2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            IOException iOException = new IOException(noSuchMethodException.getMessage());
            iOException.initCause(noSuchMethodException);
            throw iOException;
        }
        catch (IllegalAccessException illegalAccessException) {
            IOException iOException = new IOException(illegalAccessException.getMessage());
            iOException.initCause(illegalAccessException);
            throw iOException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            IOException iOException = new IOException(invocationTargetException.getMessage());
            iOException.initCause(throwable);
            throw iOException;
        }
    }

    private static void writeProperties(Writer writer, Properties properties) throws IOException {
        for (String string : properties.keySet()) {
            writer.write(INDENT);
            writer.write("<property name=\"");
            writer.write(string);
            writer.write("\" value=\"");
            writer.write(XMLUtil.toAttributeValue((String)properties.getProperty(string)));
            writer.write("\"/>" + XMLSettingsSupport.LINE_SEPARATOR);
        }
    }

    private static Properties getProperties(Object object) throws IOException {
        try {
            Method method = object.getClass().getDeclaredMethod("writeProperties", Properties.class);
            method.setAccessible(true);
            Properties properties = new Properties();
            method.invoke(object, properties);
            return properties;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            IOException iOException = new IOException(noSuchMethodException.getMessage());
            iOException.initCause(noSuchMethodException);
            throw iOException;
        }
        catch (IllegalAccessException illegalAccessException) {
            IOException iOException = new IOException(illegalAccessException.getMessage());
            iOException.initCause(illegalAccessException);
            throw iOException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            IOException iOException = new IOException(invocationTargetException.getMessage());
            iOException.initCause(throwable);
            throw iOException;
        }
    }

    private static class Reader
    extends DefaultHandler
    implements LexicalHandler {
        private static final String ELM_PROPERTY = "property";
        private static final String ATR_PROPERTY_NAME = "name";
        private static final String ATR_PROPERTY_VALUE = "value";
        private Properties props = new Properties();
        private String publicId;

        Reader() {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (this.publicId != null && this.publicId.equals(string)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return null;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (ELM_PROPERTY.equals(string3)) {
                String string4 = attributes.getValue(ATR_PROPERTY_NAME);
                String string5 = attributes.getValue(ATR_PROPERTY_VALUE);
                this.props.setProperty(string4, string5);
            }
        }

        public void parse(java.io.Reader reader) throws IOException {
            try {
                XMLReader xMLReader = XMLUtil.createXMLReader((boolean)false, (boolean)false);
                xMLReader.setContentHandler(this);
                xMLReader.setEntityResolver(this);
                InputSource inputSource = new InputSource(reader);
                try {
                    xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
                }
                catch (SAXException sAXException) {
                    XMLSettingsSupport.err.warning("Warning: XML parser does not support lexical-handler feature.");
                }
                xMLReader.parse(inputSource);
            }
            catch (SAXException sAXException) {
                IOException iOException = new IOException();
                iOException.initCause(sAXException);
                throw iOException;
            }
        }

        public Properties getProperties() {
            return this.props;
        }

        public String getPublicID() {
            return this.publicId;
        }

        @Override
        public void startDTD(String string, String string2, String string3) throws SAXException {
            this.publicId = string2;
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String string) throws SAXException {
        }

        @Override
        public void endEntity(String string) throws SAXException {
        }

        @Override
        public void comment(char[] cArray, int n, int n2) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }
    }
}

