/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.HmacCore;
import com.sun.crypto.provider.PKCS12PBECipherCore;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class HmacPKCS12PBESHA1
extends HmacCore {
    public HmacPKCS12PBESHA1() throws NoSuchAlgorithmException {
        super("SHA1", 64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] derivedKey;
        char[] passwdChars;
        byte[] salt = null;
        int iCount = 0;
        if (key instanceof PBEKey) {
            PBEKey pbeKey = (PBEKey)key;
            passwdChars = pbeKey.getPassword();
            salt = pbeKey.getSalt();
            iCount = pbeKey.getIterationCount();
        } else if (key instanceof SecretKey) {
            byte[] passwdBytes;
            if (!key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3) || (passwdBytes = key.getEncoded()) == null) {
                throw new InvalidKeyException("Missing password");
            }
            passwdChars = new char[passwdBytes.length];
            for (int i = 0; i < passwdChars.length; ++i) {
                passwdChars[i] = (char)(passwdBytes[i] & 0x7F);
            }
            Arrays.fill(passwdBytes, (byte)0);
        } else {
            throw new InvalidKeyException("SecretKey of PBE type required");
        }
        try {
            if (params == null) {
                if (salt == null || iCount == 0) {
                    throw new InvalidAlgorithmParameterException("PBEParameterSpec required for salt and iteration count");
                }
            } else {
                if (!(params instanceof PBEParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("PBEParameterSpec type required");
                }
                PBEParameterSpec pbeParams = (PBEParameterSpec)params;
                if (salt != null) {
                    if (!Arrays.equals(salt, pbeParams.getSalt())) {
                        throw new InvalidAlgorithmParameterException("Inconsistent value of salt between key and params");
                    }
                } else {
                    salt = pbeParams.getSalt();
                }
                if (iCount != 0) {
                    if (iCount != pbeParams.getIterationCount()) {
                        throw new InvalidAlgorithmParameterException("Different iteration count between key and params");
                    }
                } else {
                    iCount = pbeParams.getIterationCount();
                }
            }
            if (salt.length < 8) {
                throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
            }
            if (iCount <= 0) {
                throw new InvalidAlgorithmParameterException("IterationCount must be a positive number");
            }
            derivedKey = PKCS12PBECipherCore.derive(passwdChars, salt, iCount, this.engineGetMacLength(), 3);
        }
        finally {
            Arrays.fill(passwdChars, '\u0000');
        }
        SecretKeySpec cipherKey = new SecretKeySpec(derivedKey, "HmacSHA1");
        super.engineInit(cipherKey, null);
    }
}

