/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.Shadowable;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.ISkinSimple;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public class ComponentRoseParticipant
extends AbstractTextualComponent {
    private final HColor back;
    private final HColor foregroundColor;
    private final double deltaShadow;
    private final double roundCorner;
    private final double diagonalCorner;
    private final UStroke stroke;
    private final double minWidth;
    private final boolean collections;
    private final double padding;

    public ComponentRoseParticipant(Style style, Style stereo, Display stringsToDisplay, ISkinSimple spriteContainer, double minWidth, boolean collections, double padding) {
        super(style, stereo, LineBreakStrategy.NONE, 7, 7, 7, spriteContainer, stringsToDisplay, false);
        this.roundCorner = style.value(PName.RoundCorner).asInt(false);
        this.diagonalCorner = style.value(PName.DiagonalCorner).asInt(false);
        Fashion biColor = style.getSymbolContext(this.getIHtmlColorSet());
        this.stroke = style.getStroke();
        this.padding = padding;
        this.minWidth = minWidth;
        this.collections = collections;
        this.back = biColor.getBackColor();
        this.deltaShadow = biColor.getDeltaShadow();
        this.foregroundColor = biColor.getForeColor();
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(UTranslate.dx(this.padding));
        if (this.foregroundColor != null) {
            ug = ug.apply(this.foregroundColor);
        }
        if (this.back != null) {
            ug = ug.apply(this.back.bg());
        }
        ug = ug.apply(this.stroke);
        Shadowable rect = URectangle.build(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder)).rounded(this.roundCorner).diagonalCorner(this.diagonalCorner);
        rect.setDeltaShadow(this.deltaShadow);
        if (this.collections) {
            ug.apply(UTranslate.dx(this.getDeltaCollection())).draw(rect);
            ug = ug.apply(UTranslate.dy(this.getDeltaCollection()));
        }
        ug.draw(rect);
        ug = ug.apply(UStroke.simple());
        TextBlock textBlock = this.getTextBlock();
        textBlock.drawU(ug.apply(new UTranslate((double)this.getMarginX1() + this.suppWidth(stringBounder) / 2.0, this.getMarginY())));
    }

    private double getDeltaCollection() {
        if (this.collections) {
            return 4.0;
        }
        return 0.0;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + this.deltaShadow + 1.0 + this.getDeltaCollection();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + this.deltaShadow + this.getDeltaCollection() + 2.0 * this.padding;
    }

    @Override
    protected double getPureTextWidth(StringBounder stringBounder) {
        return Math.max(super.getPureTextWidth(stringBounder), this.minWidth);
    }

    private final double suppWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) - super.getPureTextWidth(stringBounder);
    }
}

