/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.phonetic;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.Encoder;
import org.apache.commons.codec.language.Caverphone2;
import org.apache.commons.codec.language.ColognePhonetic;
import org.apache.commons.codec.language.DoubleMetaphone;
import org.apache.commons.codec.language.Metaphone;
import org.apache.commons.codec.language.Nysiis;
import org.apache.commons.codec.language.RefinedSoundex;
import org.apache.commons.codec.language.Soundex;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.phonetic.PhoneticFilter;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.ResourceLoaderAware;

public class PhoneticFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "phonetic";
    public static final String ENCODER = "encoder";
    public static final String INJECT = "inject";
    public static final String MAX_CODE_LENGTH = "maxCodeLength";
    private static final String PACKAGE_CONTAINING_ENCODERS = "org.apache.commons.codec.language.";
    private static final Map<String, Class<? extends Encoder>> registry = Map.of("DoubleMetaphone".toUpperCase(Locale.ROOT), DoubleMetaphone.class, "Metaphone".toUpperCase(Locale.ROOT), Metaphone.class, "Soundex".toUpperCase(Locale.ROOT), Soundex.class, "RefinedSoundex".toUpperCase(Locale.ROOT), RefinedSoundex.class, "Caverphone".toUpperCase(Locale.ROOT), Caverphone2.class, "ColognePhonetic".toUpperCase(Locale.ROOT), ColognePhonetic.class, "Nysiis".toUpperCase(Locale.ROOT), Nysiis.class);
    final boolean inject;
    private final String name;
    private final Integer maxCodeLength;
    private Class<? extends Encoder> clazz = null;
    private Method setMaxCodeLenMethod = null;

    public PhoneticFilterFactory(Map<String, String> args) {
        super(args);
        this.inject = this.getBoolean(args, INJECT, true);
        this.name = this.require(args, ENCODER);
        String v = this.get(args, MAX_CODE_LENGTH);
        this.maxCodeLength = v != null ? Integer.valueOf(v) : null;
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public PhoneticFilterFactory() {
        throw PhoneticFilterFactory.defaultCtorException();
    }

    public void inform(ResourceLoader loader) throws IOException {
        this.clazz = registry.get(this.name.toUpperCase(Locale.ROOT));
        if (this.clazz == null) {
            this.clazz = this.resolveEncoder(this.name, loader);
        }
        if (this.maxCodeLength != null) {
            try {
                this.setMaxCodeLenMethod = this.clazz.getMethod("setMaxCodeLen", Integer.TYPE);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Encoder " + this.name + " / " + this.clazz + " does not support maxCodeLength", e);
            }
        }
        this.getEncoder();
    }

    private Class<? extends Encoder> resolveEncoder(String name, ResourceLoader loader) {
        Object lookupName = name;
        if (name.indexOf(46) == -1) {
            lookupName = PACKAGE_CONTAINING_ENCODERS + name;
        }
        try {
            return ((Encoder)loader.newInstance((String)lookupName, Encoder.class)).getClass();
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Error loading encoder '" + name + "': must be full class name or one of " + registry.keySet(), e);
        }
    }

    protected Encoder getEncoder() {
        try {
            Encoder encoder = this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (this.maxCodeLength != null && this.setMaxCodeLenMethod != null) {
                this.setMaxCodeLenMethod.invoke((Object)encoder, this.maxCodeLength);
            }
            return encoder;
        }
        catch (Exception e) {
            Throwable t = e instanceof InvocationTargetException ? e.getCause() : e;
            throw new IllegalArgumentException("Error initializing encoder: " + this.name + " / " + this.clazz, t);
        }
    }

    public PhoneticFilter create(TokenStream input) {
        return new PhoneticFilter(input, this.getEncoder(), this.inject);
    }
}

