// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import { KmsKeyringClass, getClient, limitRegions, excludeRegions, cacheClients, } from '@aws-crypto/kms-keyring';
import { immutableClass, KeyringNode, } from '@aws-crypto/material-management-node';
import { KMS } from 'aws-sdk';
import { version } from './version';
const getKmsClient = getClient(KMS, {
    customUserAgent: `AwsEncryptionSdkJavascriptNodejs/${version}`,
});
const cacheKmsClients = cacheClients(getKmsClient);
export class KmsKeyringNode extends KmsKeyringClass(KeyringNode) {
    constructor({ clientProvider = cacheKmsClients, keyIds, generatorKeyId, grantTokens, discovery, } = {}) {
        super({ clientProvider, keyIds, generatorKeyId, grantTokens, discovery });
    }
}
immutableClass(KmsKeyringNode);
export { getKmsClient, cacheKmsClients, getClient, limitRegions, excludeRegions, cacheClients, KMS, };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia21zX2tleXJpbmdfbm9kZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9rbXNfa2V5cmluZ19ub2RlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLG9FQUFvRTtBQUNwRSxzQ0FBc0M7QUFFdEMsT0FBTyxFQUNMLGVBQWUsRUFJZixTQUFTLEVBQ1QsWUFBWSxFQUNaLGNBQWMsRUFDZCxZQUFZLEdBQ2IsTUFBTSx5QkFBeUIsQ0FBQTtBQUNoQyxPQUFPLEVBQ0wsY0FBYyxFQUNkLFdBQVcsR0FHWixNQUFNLHNDQUFzQyxDQUFBO0FBQzdDLE9BQU8sRUFBRSxHQUFHLEVBQUUsTUFBTSxTQUFTLENBQUE7QUFDN0IsT0FBTyxFQUFFLE9BQU8sRUFBRSxNQUFNLFdBQVcsQ0FBQTtBQUNuQyxNQUFNLFlBQVksR0FBRyxTQUFTLENBQUMsR0FBRyxFQUFFO0lBQ2xDLGVBQWUsRUFBRSxvQ0FBb0MsT0FBTyxFQUFFO0NBQy9ELENBQUMsQ0FBQTtBQUNGLE1BQU0sZUFBZSxHQUFHLFlBQVksQ0FBQyxZQUFZLENBQUMsQ0FBQTtBQVNsRCxNQUFNLE9BQU8sY0FBZSxTQUFRLGVBQWUsQ0FDakQsV0FBbUMsQ0FDcEM7SUFDQyxZQUFZLEVBQ1YsY0FBYyxHQUFHLGVBQWUsRUFDaEMsTUFBTSxFQUNOLGNBQWMsRUFDZCxXQUFXLEVBQ1gsU0FBUyxNQUNjLEVBQUU7UUFDekIsS0FBSyxDQUFDLEVBQUUsY0FBYyxFQUFFLE1BQU0sRUFBRSxjQUFjLEVBQUUsV0FBVyxFQUFFLFNBQVMsRUFBRSxDQUFDLENBQUE7SUFDM0UsQ0FBQztDQUNGO0FBQ0QsY0FBYyxDQUFDLGNBQWMsQ0FBQyxDQUFBO0FBRTlCLE9BQU8sRUFDTCxZQUFZLEVBQ1osZUFBZSxFQUNmLFNBQVMsRUFDVCxZQUFZLEVBQ1osY0FBYyxFQUNkLFlBQVksRUFDWixHQUFHLEdBQ0osQ0FBQSJ9