/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.owl;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.formats.LabelFunctionalDocumentFormat;
import org.semanticweb.owlapi.functional.renderer.FunctionalSyntaxObjectRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.util.AbstractOWLStorer;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.StringComparator;

public class LabelFunctionalSyntaxStorer
extends AbstractOWLStorer {
    private static final long serialVersionUID = 40000L;

    @Override
    public boolean canStoreOntology(OWLDocumentFormat ontologyFormat) {
        return ontologyFormat instanceof LabelFunctionalDocumentFormat;
    }

    @Override
    protected void storeOntology(@Nonnull OWLOntology ontology, @Nonnull Writer writer, OWLDocumentFormat format) throws OWLOntologyStorageException {
        try {
            FunctionalSyntaxObjectRenderer renderer = new FunctionalSyntaxObjectRenderer(ontology, writer);
            renderer.setPrefixManager(new LabelPrefixManager(ontology));
            ontology.accept(renderer);
            writer.flush();
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    static class LabelPrefixManager
    implements PrefixManager {
        private static final long serialVersionUID = 40000L;
        @Nonnull
        private final OWLOntology ontology;
        @Nonnull
        private final PrefixManager delegate;

        LabelPrefixManager(@Nonnull OWLOntology ontology) {
            this.ontology = ontology;
            OWLDocumentFormat ontologyFormat = ontology.getOWLOntologyManager().getOntologyFormat(ontology);
            this.delegate = ontologyFormat instanceof PrefixManager ? (PrefixManager)((Object)ontologyFormat) : new DefaultPrefixManager();
        }

        @Override
        public String getPrefixIRI(IRI iri) {
            for (OWLAnnotationAssertionAxiom annotation : this.ontology.getAnnotationAssertionAxioms(iri)) {
                OWLAnnotationValue value;
                if (!annotation.getProperty().isLabel() || !((value = annotation.getValue()) instanceof OWLLiteral)) continue;
                return '<' + ((OWLLiteral)value).getLiteral() + '>';
            }
            return this.delegate.getPrefixIRI(iri);
        }

        @Override
        public String getPrefixIRIIgnoreQName(IRI iri) {
            for (OWLAnnotationAssertionAxiom annotation : this.ontology.getAnnotationAssertionAxioms(iri)) {
                OWLAnnotationValue value;
                if (!annotation.getProperty().isLabel() || !((value = annotation.getValue()) instanceof OWLLiteral)) continue;
                return '<' + ((OWLLiteral)value).getLiteral() + '>';
            }
            return this.delegate.getPrefixIRIIgnoreQName(iri);
        }

        @Override
        public String getDefaultPrefix() {
            return this.delegate.getDefaultPrefix();
        }

        @Override
        public boolean containsPrefixMapping(String prefixName) {
            return this.delegate.containsPrefixMapping(prefixName);
        }

        @Override
        public String getPrefix(String prefixName) {
            return this.delegate.getPrefix(prefixName);
        }

        @Override
        public Map<String, String> getPrefixName2PrefixMap() {
            return this.delegate.getPrefixName2PrefixMap();
        }

        @Override
        public IRI getIRI(String prefixIRI) {
            return this.delegate.getIRI(prefixIRI);
        }

        @Override
        public Set<String> getPrefixNames() {
            return this.delegate.getPrefixNames();
        }

        @Override
        public StringComparator getPrefixComparator() {
            return this.delegate.getPrefixComparator();
        }

        @Override
        public void setPrefixComparator(StringComparator comparator) {
            this.delegate.setPrefixComparator(comparator);
        }

        @Override
        public void setDefaultPrefix(String defaultPrefix) {
        }

        @Override
        public void setPrefix(String prefixName, String prefix) {
        }

        @Override
        public void copyPrefixesFrom(PrefixManager from) {
        }

        @Override
        public void copyPrefixesFrom(Map<String, String> from) {
        }

        @Override
        public void unregisterNamespace(String namespace) {
        }

        @Override
        public void clear() {
        }
    }
}

