/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PrinterGraphics;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import org.freehep.graphics2d.AbstractVectorGraphics;
import org.freehep.graphics2d.ArrayPath;
import org.freehep.graphics2d.GenericTagHandler;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphics2d.WebColor;
import org.freehep.graphics2d.font.FontEncoder;

public class PixelGraphics2D
extends AbstractVectorGraphics {
    public static final RenderingHints.Key KEY_SYMBOL_BLIT = new SymbolBlitKey();
    public static final Object VALUE_SYMBOL_BLIT_ON = Boolean.TRUE;
    public static final Object VALUE_SYMBOL_BLIT_OFF = Boolean.FALSE;
    protected Graphics2D hostGraphics;
    protected double lineWidth;
    protected int resolution;
    protected GenericTagHandler tagHandler;
    private static final int MAX_BLIT_SIZE = 32;
    private static Map symbols = new HashMap();
    private WebColor webColor;
    private static boolean displayX11 = false;
    private static boolean displayLocal = false;

    public PixelGraphics2D(Graphics graphics) {
        this();
        this.setHostGraphics(graphics);
    }

    protected PixelGraphics2D(PixelGraphics2D pixelGraphics2D) {
        super(pixelGraphics2D);
        this.setHostGraphics(pixelGraphics2D.hostGraphics.create());
    }

    protected PixelGraphics2D() {
    }

    protected void setHostGraphics(Graphics graphics) {
        this.hostGraphics = (Graphics2D)graphics;
        this.resolution = graphics instanceof PrinterGraphics ? 0 : 1;
        this.tagHandler = new GenericTagHandler(this.hostGraphics);
        super.setBackground(this.hostGraphics.getBackground());
        super.setColor(this.hostGraphics.getColor());
        super.setPaint(this.hostGraphics.getPaint());
        super.setFont(this.hostGraphics.getFont());
        Stroke stroke = this.hostGraphics.getStroke();
        if (stroke instanceof BasicStroke) {
            this.lineWidth = ((BasicStroke)stroke).getLineWidth();
        }
        this.webColor = WebColor.create(this.getColor());
        this.setRenderingHint(KEY_SYMBOL_BLIT, VALUE_SYMBOL_BLIT_ON);
    }

    public void startExport() {
    }

    public void endExport() {
    }

    public void printComment(String string) {
    }

    public Graphics create(double d, double d2, double d3, double d4) {
        PixelGraphics2D pixelGraphics2D = new PixelGraphics2D(this);
        pixelGraphics2D.translate(d, d2);
        pixelGraphics2D.clipRect(0.0, 0.0, d3, d4);
        return pixelGraphics2D;
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.hostGraphics.clearRect(n, n2, n3, n4);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.hostGraphics.clipRect(n, n2, n3, n4);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.hostGraphics.copyArea(n, n2, n3, n4, n5, n6);
    }

    public Graphics create() {
        return new PixelGraphics2D(this);
    }

    public void dispose() {
        this.hostGraphics.dispose();
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.hostGraphics.drawArc(n, n2, n3, n4, n5, n6);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.hostGraphics.drawImage(image, n, n2, this.getPrintColor(color), imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.hostGraphics.drawImage(image, n, n2, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.hostGraphics.drawImage(image, n, n2, n3, n4, this.getPrintColor(color), imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.hostGraphics.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return this.hostGraphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, this.getPrintColor(color), imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.hostGraphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.hostGraphics.drawLine(n, n2, n3, n4);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.hostGraphics.drawOval(n, n2, n3, n4);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.hostGraphics.drawPolygon(nArray, nArray2, n);
    }

    public void drawPolygon(Polygon polygon) {
        this.hostGraphics.drawPolygon(polygon);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.hostGraphics.drawPolyline(nArray, nArray2, n);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.hostGraphics.drawRect(n, n2, n3, n4);
    }

    public void drawString(String string, int n, int n2) {
        string = FontEncoder.getEncodedString(string, this.getFont().getName());
        this.hostGraphics.drawString(string, n, n2);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.hostGraphics.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.hostGraphics.fillOval(n, n2, n3, n4);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.hostGraphics.fillPolygon(nArray, nArray2, n);
    }

    public void fillPolygon(Polygon polygon) {
        this.hostGraphics.fillPolygon(polygon);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.hostGraphics.fillRect(n, n2, n3, n4);
    }

    public void drawSymbol(double d, double d2, double d3, int n) {
        if (d3 <= 0.0) {
            return;
        }
        int n2 = (int)Math.ceil(d3);
        if (n2 > 32 || this.lineWidth != 1.0 || !PixelGraphics2D.isDisplayLocal() || this.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON || this.getRenderingHint(KEY_SYMBOL_BLIT) == VALUE_SYMBOL_BLIT_OFF) {
            super.drawSymbol(d, d2, d3, n);
            return;
        }
        this.blitSymbol(d, d2, n2, n, false);
    }

    public void fillSymbol(double d, double d2, double d3, int n) {
        if (d3 <= 0.0) {
            return;
        }
        int n2 = (int)Math.ceil(d3);
        if (n2 > 32 || this.lineWidth != 1.0 || !PixelGraphics2D.isDisplayLocal() || this.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON || this.getRenderingHint(KEY_SYMBOL_BLIT) == VALUE_SYMBOL_BLIT_OFF) {
            super.fillSymbol(d, d2, d3, n);
            return;
        }
        this.blitSymbol(d, d2, n2, n, true);
    }

    public void fillAndDrawSymbol(double d, double d2, double d3, int n, Color color) {
        Color color2 = this.getColor();
        this.setColor(color);
        super.fillSymbol(d, d2, d3, n);
        this.setColor(color2);
        super.drawSymbol(d, d2, d3, n);
    }

    private void blitSymbol(double d, double d2, int n, int n2, boolean bl) {
        Image[][][] imageArray = (Image[][][])symbols.get(this.webColor);
        if (imageArray == null) {
            imageArray = new Image[2][10][32];
            symbols.put(this.webColor, imageArray);
        }
        Image image = imageArray[bl ? 1 : 0][n2][n - 1];
        int n3 = n + 1;
        double d3 = (double)n3 / 2.0;
        if (image == null) {
            image = this.getDeviceConfiguration().createCompatibleImage(n3 + 1, n3 + 1, 2);
            VectorGraphics vectorGraphics = VectorGraphics.create(image.getGraphics());
            Composite composite = vectorGraphics.getComposite();
            vectorGraphics.setComposite(AlphaComposite.Clear);
            vectorGraphics.fillRect(0, 0, n, n);
            vectorGraphics.setComposite(composite);
            vectorGraphics.setColor(this.getColor());
            if (bl) {
                this.fillSymbol(vectorGraphics, d3, d3, n, n2);
            } else {
                this.drawSymbol(vectorGraphics, d3, d3, n, n2);
            }
            imageArray[bl ? 1 : 0][n2][n - 1] = image;
        }
        this.drawImage(image, (int)(d - d3), (int)(d2 - d3), null);
    }

    public void setLineWidth(double d) {
        super.setLineWidth(d);
        this.lineWidth = d;
    }

    public Shape getClip() {
        return this.hostGraphics.getClip();
    }

    public Rectangle getClipBounds() {
        return this.hostGraphics.getClipBounds();
    }

    public Rectangle getClipBounds(Rectangle rectangle) {
        return this.hostGraphics.getClipBounds(rectangle);
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.hostGraphics.getFontMetrics(font);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.hostGraphics.setClip(n, n2, n3, n4);
    }

    public void setClip(Shape shape) {
        this.hostGraphics.setClip(shape);
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        super.setFont(font);
        if (font.getName().equals("Symbol") || font.getName().equals("ZapfDingbats")) {
            Font font2 = new Font("Serif", font.getSize(), font.getStyle());
            font = font2.deriveFont(font.getSize2D());
        }
        this.hostGraphics.setFont(font);
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        if (color.equals(this.getColor())) {
            return;
        }
        super.setColor(color);
        this.hostGraphics.setColor(this.getPrintColor(color));
        this.webColor = WebColor.create(color);
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        if (paint.equals(this.getPaint())) {
            return;
        }
        if (paint instanceof Color) {
            this.setColor((Color)paint);
        } else {
            super.setPaint(paint);
            this.hostGraphics.setPaint(paint);
        }
    }

    public void setPaintMode() {
        this.hostGraphics.setPaintMode();
    }

    public void setXORMode(Color color) {
        this.hostGraphics.setXORMode(this.getPrintColor(color));
    }

    public void translate(int n, int n2) {
        this.hostGraphics.translate(n, n2);
    }

    public void addRenderingHints(Map map) {
        this.hostGraphics.addRenderingHints(map);
    }

    public void clip(Shape shape) {
        this.hostGraphics.clip(shape);
    }

    public void draw(Shape shape) {
        this.hostGraphics.draw(shape);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.hostGraphics.drawGlyphVector(glyphVector, f, f2);
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        this.hostGraphics.drawImage(bufferedImage, bufferedImageOp, n, n2);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return this.hostGraphics.drawImage(image, affineTransform, imageObserver);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.hostGraphics.drawRenderableImage(renderableImage, affineTransform);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.hostGraphics.drawRenderedImage(renderedImage, affineTransform);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        this.hostGraphics.drawString(attributedCharacterIterator, f, f2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.hostGraphics.drawString(attributedCharacterIterator, n, n2);
    }

    public void drawString(String string, float f, float f2) {
        string = FontEncoder.getEncodedString(string, this.getFont().getName());
        this.hostGraphics.drawString(string, f, f2);
    }

    public void fill(Shape shape) {
        this.hostGraphics.fill(shape);
    }

    public Composite getComposite() {
        return this.hostGraphics.getComposite();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.hostGraphics.getDeviceConfiguration();
    }

    public FontRenderContext getFontRenderContext() {
        return this.hostGraphics.getFontRenderContext();
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.hostGraphics.getRenderingHint(key);
    }

    public RenderingHints getRenderingHints() {
        return this.hostGraphics.getRenderingHints();
    }

    public Stroke getStroke() {
        return this.hostGraphics.getStroke();
    }

    public AffineTransform getTransform() {
        return this.hostGraphics.getTransform();
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return this.hostGraphics.hit(rectangle, shape, bl);
    }

    public void rotate(double d) {
        this.hostGraphics.rotate(d);
    }

    public void rotate(double d, double d2, double d3) {
        this.hostGraphics.rotate(d, d2, d3);
    }

    public void scale(double d, double d2) {
        this.hostGraphics.scale(d, d2);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.hostGraphics.setBackground(this.getPrintColor(color));
    }

    public void setComposite(Composite composite) {
        this.hostGraphics.setComposite(composite);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.hostGraphics.setRenderingHint(key, object);
    }

    public void setRenderingHints(Map map) {
        this.hostGraphics.setRenderingHints(map);
    }

    public void setStroke(Stroke stroke) {
        this.hostGraphics.setStroke(stroke);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.hostGraphics.setTransform(affineTransform);
    }

    public void shear(double d, double d2) {
        this.hostGraphics.shear(d, d2);
    }

    public void transform(AffineTransform affineTransform) {
        this.hostGraphics.transform(affineTransform);
    }

    public void translate(double d, double d2) {
        this.hostGraphics.translate(d, d2);
    }

    public void clearRect(double d, double d2, double d3, double d4) {
        this.clearRect((int)d, (int)d2, (int)d3, (int)d4);
    }

    public void clipRect(double d, double d2, double d3, double d4) {
        this.clipRect((int)d, (int)d2, (int)d3, (int)d4);
    }

    public void drawString(String string, double d, double d2) {
        this.drawString(string, (int)Math.round(d), (int)Math.round(d2));
    }

    public void setClip(double d, double d2, double d3, double d4) {
        this.setClip(new Rectangle2D.Double(d, d2, d3, d4));
    }

    public String toString() {
        return "PixelGraphics2D[" + this.hostGraphics.toString() + "]";
    }

    public static boolean isDisplayX11() {
        return displayX11;
    }

    public static boolean isDisplayLocal() {
        return displayLocal;
    }

    protected Shape createShape(double[] dArray, double[] dArray2, int n, boolean bl) {
        return new ArrayPath(dArray, dArray2, n, bl, this.resolution);
    }

    static {
        try {
            Class<?> clazz = Class.forName("sun.awt.X11GraphicsEnvironment");
            displayX11 = true;
            Method method = clazz.getMethod("isDisplayLocal", null);
            Boolean bl = (Boolean)method.invoke(null, null);
            displayLocal = bl;
        }
        catch (LinkageError linkageError) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            displayLocal = true;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    static class SymbolBlitKey
    extends RenderingHints.Key {
        public SymbolBlitKey() {
            super(94025);
        }

        public boolean isCompatibleValue(Object object) {
            if (object.equals(VALUE_SYMBOL_BLIT_ON)) {
                return true;
            }
            return object.equals(VALUE_SYMBOL_BLIT_OFF);
        }

        public String toString() {
            return "Symbol Blitting enable key";
        }
    }
}

