/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core;

import org.sunflow.SunflowAPI;
import org.sunflow.core.CameraLens;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.RenderObject;
import org.sunflow.math.Matrix4;
import org.sunflow.math.MovingMatrix4;
import org.sunflow.math.Point3;
import org.sunflow.system.UI;

public class Camera
implements RenderObject {
    private final CameraLens lens;
    private float shutterOpen;
    private float shutterClose;
    private MovingMatrix4 c2w;
    private MovingMatrix4 w2c;

    public Camera(CameraLens cameraLens) {
        this.lens = cameraLens;
        this.c2w = new MovingMatrix4(null);
        this.w2c = new MovingMatrix4(null);
        this.shutterClose = 0.0f;
        this.shutterOpen = 0.0f;
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.shutterOpen = parameterList.getFloat("shutter.open", this.shutterOpen);
        this.shutterClose = parameterList.getFloat("shutter.close", this.shutterClose);
        this.c2w = parameterList.getMovingMatrix("transform", this.c2w);
        this.w2c = this.c2w.inverse();
        if (this.w2c == null) {
            UI.printWarning(UI.Module.CAM, "Unable to compute camera's inverse transform", new Object[0]);
            return false;
        }
        return this.lens.update(parameterList, sunflowAPI);
    }

    public float getTime(float f) {
        if (this.shutterOpen >= this.shutterClose) {
            return this.shutterOpen;
        }
        f = (double)f < 0.5 ? -1.0f + (float)Math.sqrt(2.0f * f) : 1.0f - (float)Math.sqrt(2.0f - 2.0f * f);
        f = 0.5f * (f + 1.0f);
        return (1.0f - f) * this.shutterOpen + f * this.shutterClose;
    }

    public Ray getRay(float f, float f2, int n, int n2, double d, double d2, float f3) {
        Ray ray = this.lens.getRay(f, f2, n, n2, d, d2, f3);
        if (ray != null) {
            ray = ray.transform(this.c2w.sample(f3));
            ray.normalize();
        }
        return ray;
    }

    Ray getRay(Point3 point3, float f) {
        return new Ray(this.c2w == null ? new Point3(0.0f, 0.0f, 0.0f) : this.c2w.sample(f).transformP(new Point3(0.0f, 0.0f, 0.0f)), point3);
    }

    Matrix4 getCameraToWorld(float f) {
        return this.c2w == null ? Matrix4.IDENTITY : this.c2w.sample(f);
    }

    Matrix4 getWorldToCamera(float f) {
        return this.w2c == null ? Matrix4.IDENTITY : this.w2c.sample(f);
    }
}

